/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.provider;

import com.matez.wildnature.Main;
import com.matez.wildnature.customizable.CommonConfig;
import com.matez.wildnature.gui.screen.WNWorldConfigScreen;
import com.matez.wildnature.world.gen.biomes.layer.WNBiomeLayer;
import com.matez.wildnature.world.gen.biomes.setup.WNGenSettings;
import com.matez.wildnature.world.gen.chunk.WNChunkGeneratorOverworld;
import com.matez.wildnature.world.gen.chunk.WNChunkGeneratorType;
import com.matez.wildnature.world.gen.chunk.WNSimplexChunkGenerator;
import com.matez.wildnature.world.gen.provider.WNBiomeProviderType;
import com.matez.wildnature.world.gen.provider.WildNatureBiomeProvider;
import java.util.function.LongFunction;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.CreateBuffetWorldScreen;
import net.minecraft.client.gui.screen.CreateFlatWorldScreen;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.biome.provider.IBiomeProviderSettings;
import net.minecraft.world.biome.provider.OverworldBiomeProviderSettings;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.AddBambooForestLayer;
import net.minecraft.world.gen.layer.EdgeBiomeLayer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WNWorldType
extends WorldType {
    public WNWorldType(String name) {
        super(name);
    }

    public ChunkGenerator<?> createChunkGenerator(World world) {
        System.out.println("Generating dimension: " + world.func_201675_m().func_186058_p().toString());
        if (world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
            Main.wnInfo("Generating WildNature World");
            Main.runningWorld = world;
            ChunkGeneratorType<WNGenSettings, WNChunkGeneratorOverworld> gen = WNChunkGeneratorType.WILDNATURE;
            ChunkGeneratorType genNether = ChunkGeneratorType.field_206912_c;
            ChunkGeneratorType genEnd = ChunkGeneratorType.field_206913_d;
            ChunkGeneratorType<WNGenSettings, WNSimplexChunkGenerator> genTest = WNChunkGeneratorType.SIMPLEX_TEST;
            WNGenSettings overworldgensettings1 = (WNGenSettings)gen.func_205483_a();
            overworldgensettings1.func_214969_a(Blocks.field_150348_b.func_176223_P());
            overworldgensettings1.func_214970_b(Blocks.field_150355_j.func_176223_P());
            BiomeProviderType<OverworldBiomeProviderSettings, WildNatureBiomeProvider> bpt = WNBiomeProviderType.WILDNATURE;
            OverworldBiomeProviderSettings overworldbiomeprovidersettings1 = ((OverworldBiomeProviderSettings)bpt.func_205458_a()).func_205441_a(new OverworldGenSettings()).func_205439_a(world.func_72912_H());
            BiomeProvider provider = bpt.func_205457_a((IBiomeProviderSettings)overworldbiomeprovidersettings1);
            if (((String)CommonConfig.generatorType.get()).equals("wildnature")) {
                return gen.create(world, provider, (GenerationSettings)overworldgensettings1);
            }
            return genTest.create(world, provider, (GenerationSettings)overworldgensettings1);
        }
        return world.func_201675_m().func_186060_c();
    }

    public <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> getBiomeLayer(IAreaFactory<T> parentLayer, OverworldGenSettings chunkSettings, LongFunction<C> contextFactory) {
        parentLayer = new WNBiomeLayer(this.getWorldType(), chunkSettings).func_202713_a((IExtendedNoiseRandom)contextFactory.apply(200L), parentLayer);
        parentLayer = AddBambooForestLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1001L), parentLayer);
        parentLayer = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)parentLayer, (int)2, contextFactory);
        parentLayer = EdgeBiomeLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), parentLayer);
        return parentLayer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onCustomizeButton(Minecraft mc, CreateWorldScreen gui) {
        if (this == WorldType.field_77138_c) {
            mc.func_147108_a((Screen)new CreateFlatWorldScreen(gui, gui.field_146334_a));
        } else if (this == WorldType.field_205394_h) {
            mc.func_147108_a((Screen)new CreateBuffetWorldScreen(gui, gui.field_146334_a));
        } else if (this == Main.WNWorldType) {
            mc.func_147108_a((Screen)new WNWorldConfigScreen(gui, gui.field_146334_a));
        }
    }
}

