/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.structures.dungeons;

import com.matez.wildnature.other.Utilities;
import com.matez.wildnature.world.gen.structures.nature.SchemFeature;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.BlockStateArgument;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class DungeonFeature
extends Feature<NoFeatureConfig> {
    private boolean virtualPlace = true;
    private BlockPos startBlockPos;
    private int rotation = 1;
    private IWorld world;
    private ArrayList<SchemFeature.BlockStatePos> blocks = new ArrayList();
    private int underground = 1;
    private int flags = 19;

    public DungeonFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51438_1_) {
        super(p_i51438_1_);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        this.startBlockPos = pos;
        this.rotation = Utilities.rint(1, 4, rand);
        this.world = worldIn;
        this.virtualPlace = false;
        return true;
    }

    public void prepareTerrainForSpawn() {
        this.virtualPlace = true;
        this.setBlocks();
        int platformHeight = this.startBlockPos.func_177979_c(this.underground).func_177956_o();
        int maxSize = 0;
        int minSize = 0;
        ArrayList<SchemFeature.BlockStatePos> platform = new ArrayList<SchemFeature.BlockStatePos>();
        ArrayList<BlockState> platformBlocks = new ArrayList<BlockState>();
        ArrayList<BlockPos> holes = new ArrayList<BlockPos>();
        for (SchemFeature.BlockStatePos block : this.blocks) {
            if (block.getPos().func_177956_o() == platformHeight) {
                platform.add(block);
                platformBlocks.add(block.getState());
                if (!this.world.func_180495_p(block.getPos().func_177977_b()).func_200132_m()) {
                    holes.add(block.getPos().func_177977_b());
                }
            }
            if (block.getPos().func_177956_o() > maxSize) {
                maxSize = block.getPos().func_177956_o();
            }
            if (block.getPos().func_177956_o() >= minSize) continue;
            minSize = block.getPos().func_177956_o();
        }
        BlockState platformBlock = (BlockState)DungeonFeature.mostCommon(platformBlocks);
        ArrayList<BlockPos> holesCopy = holes;
        while (!holesCopy.isEmpty()) {
            holes = holesCopy;
            for (BlockPos pos : holes) {
                this.world.func_180501_a(pos, platformBlock, this.flags);
                holesCopy.remove(pos);
                if (this.world.func_180495_p(pos.func_177977_b()).func_200132_m() || pos.func_177956_o() <= 1) continue;
                holesCopy.add(pos.func_177977_b());
            }
        }
    }

    public void setBlocks() {
    }

    public void Block(int x, int y, int z, BlockState state) {
        BlockPos pos = this.startBlockPos;
        int sx = this.startBlockPos.func_177958_n();
        int sy = this.startBlockPos.func_177956_o() - 1;
        int sz = this.startBlockPos.func_177952_p();
        if (this.rotation >= 1 && this.rotation <= 4) {
            pos = this.rotation == 1 ? new BlockPos(x + sx, y + sy, z + sz) : (this.rotation == 2 ? new BlockPos(-x + sx, y + sy, -z + sz) : (this.rotation == 3 ? new BlockPos(z + sx, y + sy, x + sz) : new BlockPos(-z + sx, y + sy, -x + sz)));
        } else {
            throw new IllegalArgumentException("Unknown rotation for structure at " + this.startBlockPos.toString() + " :\nrotation = " + this.rotation + " (1-4)\n   Please report it to author!");
        }
        this.blocks.add(new SchemFeature.BlockStatePos(state, pos.func_177979_c(this.underground)));
        if (!this.virtualPlace) {
            if (state.func_177230_c() == Blocks.field_189881_dj) {
                state = Blocks.field_150350_a.func_176223_P();
            }
            this.world.func_180501_a(pos.func_177979_c(this.underground), state, 19);
        }
    }

    public void Block(int x, int y, int z, String s) {
        try {
            BlockState bs = BlockStateArgument.func_197239_a().parse(new StringReader(s)).func_197231_a();
            this.Block(x, y, z, bs);
            return;
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return;
        }
    }

    public static <T> T mostCommon(List<T> list) {
        HashMap<T, Integer> map = new HashMap<T, Integer>();
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            T t;
            Integer val = (Integer)map.get(t = iterator.next());
            map.put(t, val == null ? 1 : val + 1);
        }
        Map.Entry max = null;
        for (Map.Entry e : map.entrySet()) {
            if (max != null && (Integer)e.getValue() <= (Integer)max.getValue()) continue;
            max = e;
        }
        return (T)max.getKey();
    }
}

