/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.structures.nature;

import com.google.common.collect.Sets;
import com.matez.wildnature.blocks.FloweringLeaves;
import com.matez.wildnature.blocks.FruitableLeaves;
import com.matez.wildnature.lists.WNBlocks;
import com.matez.wildnature.other.Utilities;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.LeavesBlock;
import net.minecraft.command.arguments.BlockStateArgument;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class SchemFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private ArrayList<BlockPos> addedBlocks = new ArrayList();
    private ArrayList<BlockPos> bottomBlocks = new ArrayList();
    public BlockState LEAVES = SchemFeature.notDecayingLeaf(Blocks.field_196642_W);
    public BlockState LOG = Blocks.field_196617_K.func_176223_P();
    public BlockState DIRT = Blocks.field_150346_d.func_176223_P();
    public BlockState BRANCH = this.LEAVES;
    public IWorld world;
    public BlockPos startBlockPos;
    public Random random;
    public ArrayList<BlockStatePos> addionalBlocks = new ArrayList();
    private int rotation;
    public int terrainIncrease = 0;
    private boolean canGenerate = true;
    private boolean virtualPlace = false;

    public SchemFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config, boolean doBlockNofityOnPlace) {
        super(config, doBlockNofityOnPlace);
        this.LOG = Blocks.field_196617_K.func_176223_P();
        this.BRANCH = this.LEAVES = SchemFeature.notDecayingLeaf(Blocks.field_196642_W);
    }

    public SchemFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config, boolean doBlockNofityOnPlace, BlockState log, BlockState leaves) {
        super(config, doBlockNofityOnPlace);
        this.LOG = log;
        this.BRANCH = this.LEAVES = leaves;
    }

    public void setDirt(BlockState dirt) {
        this.DIRT = dirt;
    }

    public static BlockState notDecayingLeaf(Block block) {
        if (block instanceof LeavesBlock) {
            return (BlockState)((LeavesBlock)block).func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true));
        }
        return block.func_176223_P();
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox p_208519_5_) {
        if (!this.canGrowTree(worldIn, position.func_177977_b(), this.getSapling())) {
            return false;
        }
        BlockPos soilPos = position.func_177977_b();
        int x = 0;
        while (SchemFeature.func_214571_e((IWorldGenerationBaseReader)worldIn, (BlockPos)soilPos)) {
            soilPos = soilPos.func_177977_b();
            ++x;
        }
        if (x >= 15) {
            return false;
        }
        this.world = (IWorld)worldIn;
        this.startBlockPos = soilPos.func_177981_b(this.terrainIncrease);
        this.random = rand;
        this.rotation = Utilities.rint(1, 4, rand);
        this.canGenerate = true;
        this.addedBlocks.clear();
        this.virtualPlace = true;
        this.setBlocks();
        this.workWithTerrain();
        this.virtualPlace = false;
        if (this.canGenerate) {
            this.setBlocks();
        }
        return true;
    }

    public boolean canGrowTree(IWorldGenerationReader world, BlockPos pos, IPlantable sapling) {
        return world.func_217375_a(pos, state -> state.canSustainPlant((IBlockReader)world, pos, Direction.UP, sapling));
    }

    public Set<BlockPos> setBlocks() {
        return Sets.newHashSet(this.addedBlocks);
    }

    public void Block(int x, int y, int z, BlockState state) {
        BlockPos pos = this.startBlockPos;
        int sx = this.startBlockPos.func_177958_n();
        int sy = this.startBlockPos.func_177956_o() - 1;
        int sz = this.startBlockPos.func_177952_p();
        if (this.rotation >= 1 && this.rotation <= 4) {
            if (this.rotation == 1) {
                pos = new BlockPos(x, y, z);
            } else if (this.rotation == 2) {
                pos = new BlockPos(x, y, z).func_190942_a(Rotation.CLOCKWISE_180);
                state = state.func_185907_a(Rotation.CLOCKWISE_180);
            } else if (this.rotation == 3) {
                pos = new BlockPos(x, y, z).func_190942_a(Rotation.CLOCKWISE_90);
                state = state.func_185907_a(Rotation.CLOCKWISE_90);
            } else {
                pos = new BlockPos(x, y, z).func_190942_a(Rotation.COUNTERCLOCKWISE_90);
                state = state.func_185907_a(Rotation.COUNTERCLOCKWISE_90);
            }
        } else {
            throw new IllegalArgumentException("Unknown rotation for tree at " + this.startBlockPos.toString() + " :\nrotation = " + this.rotation + " (1-4)\n   Please report it to author!");
        }
        pos = new BlockPos(pos.func_177958_n() + sx, pos.func_177956_o() + sy, pos.func_177952_p() + sz);
        if (this.world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j && state.func_177230_c() instanceof IWaterLoggable) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
        }
        if (state.func_177230_c() == WNBlocks.MAGNOLIA_LEAVES || state.func_177230_c() == WNBlocks.FORSYTHIA_LEAVES || Utilities.rint(0, 10) == 0) {
            if (state.func_177230_c() instanceof FloweringLeaves) {
                state = (BlockState)state.func_206870_a((IProperty)FloweringLeaves.FLOWERING, (Comparable)Boolean.valueOf(true));
            } else if (state.func_177230_c() instanceof FruitableLeaves) {
                state = (BlockState)state.func_206870_a((IProperty)((FruitableLeaves)state.func_177230_c()).getStage(), (Comparable)Integer.valueOf(Utilities.rint(1, ((FruitableLeaves)state.func_177230_c()).getMaxStages())));
            }
        }
        if (!this.virtualPlace && (this.isLeaf(state.func_177230_c()) && !this.world.func_180495_p(pos).func_200132_m() || !this.isLeaf(state.func_177230_c()))) {
            this.world.func_180501_a(pos, state, 19);
        }
        if (this.isLeaf(state.func_177230_c()) && !this.world.func_180495_p(pos).func_200132_m() || !this.isLeaf(state.func_177230_c())) {
            this.addedBlocks.add(pos);
        }
    }

    public void Block(int x, int y, int z, String s) {
        try {
            BlockState bs = BlockStateArgument.func_197239_a().parse(new StringReader(s)).func_197231_a();
            this.Block(x, y, z, bs);
            return;
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return;
        }
    }

    public void workWithTerrain() {
        int x;
        if (this.bottomBlocks == null) {
            return;
        }
        BlockPos down = null;
        for (x = 0; x < this.addedBlocks.size(); ++x) {
            if (down == null) {
                down = this.addedBlocks.get(x);
            }
            if (this.addedBlocks.get(x).func_177956_o() >= down.func_177956_o()) continue;
            down = this.addedBlocks.get(x);
        }
        for (x = 0; x < this.addedBlocks.size(); ++x) {
            if (this.addedBlocks.get(x).func_177956_o() != down.func_177956_o() + 1) continue;
            this.bottomBlocks.add(this.downBlock(this.addedBlocks.get(x), 1));
        }
        if (this.bottomBlocks.size() != 0 && this.bottomBlocks.size() != 1) {
            for (int i = 0; i < 10; ++i) {
                boolean allSolid = true;
                for (int a = 0; a < this.bottomBlocks.size(); ++a) {
                    BlockState state = this.world.func_180495_p(this.bottomBlocks.get(a).func_177979_c(i));
                    if (state.func_200132_m()) continue;
                    allSolid = false;
                    this.startBlockPos = this.startBlockPos.func_177977_b();
                    break;
                }
                if (allSolid) break;
                if (i != 9 || allSolid) continue;
                this.canGenerate = false;
            }
        }
        this.addedBlocks.clear();
        this.bottomBlocks.clear();
    }

    private BlockPos downBlock(BlockPos blockPos, int down) {
        return new BlockPos(blockPos.func_177958_n(), blockPos.func_177956_o() - down, blockPos.func_177952_p());
    }

    private boolean isLeaf(Block b) {
        return b instanceof LeavesBlock;
    }

    public static class BlockStatePos {
        private BlockState state;
        private BlockPos pos;

        public BlockStatePos(BlockState state, BlockPos pos) {
            this.state = state;
            this.pos = pos;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public BlockState getState() {
            return this.state;
        }
    }
}

