/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.maxhenkel.advancedtools.Main;
import de.maxhenkel.advancedtools.items.tools.AdvancedToolMaterial;
import de.maxhenkel.advancedtools.items.tools.StackUtils;
import java.util.Map;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeConvertTool
implements ICraftingRecipe,
IShapedRecipe<CraftingInventory> {
    private ResourceLocation id;
    private Ingredient inputTool;
    private ItemStack outputTool;
    private AdvancedToolMaterial outputMaterial;

    public RecipeConvertTool(ResourceLocation id, Ingredient inputTool, ItemStack outputTool, AdvancedToolMaterial outputMaterial) {
        this.id = id;
        this.inputTool = inputTool;
        this.outputTool = outputTool;
        this.outputMaterial = outputMaterial;
    }

    public int getRecipeWidth() {
        return 1;
    }

    public int getRecipeHeight() {
        return 1;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.getInputTool()});
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        boolean found = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            if (found) {
                return false;
            }
            if (!this.inputTool.test(inv.func_70301_a(i))) continue;
            found = true;
        }
        return found;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack input = this.getInputItem(inv);
        return this.getCraftingResult(input);
    }

    public ItemStack getCraftingResult(ItemStack input) {
        float percentage = (float)input.func_77952_i() / (float)input.func_77958_k();
        ItemStack output = this.func_77571_b().func_77946_l();
        output.func_196085_b((int)((float)output.func_77958_k() * percentage));
        EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)input), (ItemStack)output);
        return output;
    }

    private ItemStack getInputItem(CraftingInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b() || !this.inputTool.test(inv.func_70301_a(i))) continue;
            return inv.func_70301_a(i);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 1 && height >= 1;
    }

    public ItemStack func_77571_b() {
        return StackUtils.setMaterial(this.outputTool, this.outputMaterial);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public Ingredient getInputTool() {
        return this.inputTool;
    }

    public ItemStack getOutputTool() {
        return this.outputTool;
    }

    public AdvancedToolMaterial getOutputMaterial() {
        return this.outputMaterial;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Main.CRAFTING_CONVERT_TOOL;
    }

    public static class RecipeConvertToolSerializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeConvertTool> {
        public RecipeConvertTool read(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return new RecipeConvertTool(resourceLocation, Ingredient.func_199802_a((JsonElement)jsonObject.get("input")), ShapedRecipe.func_199798_a((JsonObject)jsonObject.getAsJsonObject("result")), AdvancedToolMaterial.byName(jsonObject.getAsJsonObject("result").get("material").getAsString()));
        }

        public RecipeConvertTool read(ResourceLocation resourceLocation, PacketBuffer packetBuffer) {
            return new RecipeConvertTool(packetBuffer.func_192575_l(), Ingredient.func_199566_b((PacketBuffer)packetBuffer), packetBuffer.func_150791_c(), AdvancedToolMaterial.byName(packetBuffer.func_218666_n()));
        }

        public void write(PacketBuffer packetBuffer, RecipeConvertTool recipe) {
            packetBuffer.func_192572_a(recipe.func_199560_c());
            recipe.getInputTool().func_199564_a(packetBuffer);
            packetBuffer.func_150788_a(recipe.getOutputTool());
            packetBuffer.func_180714_a(recipe.getOutputMaterial().getName());
        }
    }
}

