/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.integration.jei.category.apply_enchantment;

import com.google.common.collect.ImmutableList;
import de.maxhenkel.advancedtools.ModItems;
import de.maxhenkel.advancedtools.integration.jei.JEIPlugin;
import de.maxhenkel.advancedtools.integration.jei.category.apply_enchantment.EnchantmentRecipe;
import de.maxhenkel.advancedtools.items.tools.StackUtils;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class ApplyEnchantmentRecipeCategory
implements IRecipeCategory<EnchantmentRecipe> {
    private IGuiHelper helper;

    public ApplyEnchantmentRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
    }

    public IDrawable getBackground() {
        return this.helper.createDrawable(new ResourceLocation("advancedtools", "textures/gui/jei_crafting.png"), 0, 0, 116, 54);
    }

    public IDrawable getIcon() {
        return this.helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.ENCHANTMENT));
    }

    public void setIngredients(EnchantmentRecipe recipe, IIngredients ingredients) {
        ItemStack enchantment = new ItemStack((IItemProvider)ModItems.ENCHANTMENT);
        ModItems.ENCHANTMENT.setEnchantment(enchantment, recipe.getEnchantment().field_76302_b, recipe.getEnchantment().field_76303_c);
        ItemStack tool = new ItemStack((IItemProvider)recipe.getAbstractTool());
        StackUtils.setMaterial(tool, recipe.getMaterial());
        ingredients.setInputs(VanillaTypes.ITEM, (List)ImmutableList.of((Object)enchantment, (Object)tool));
        ItemStack tool2 = recipe.getAbstractTool().applyEnchantment(tool, enchantment);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)tool2);
    }

    public String getTitle() {
        return new TranslationTextComponent("jei.enchanting", new Object[0]).func_150254_d();
    }

    public ResourceLocation getUid() {
        return JEIPlugin.CATEGORY_ENCHANT;
    }

    public Class<? extends EnchantmentRecipe> getRecipeClass() {
        return EnchantmentRecipe.class;
    }

    public void setRecipe(IRecipeLayout layout, EnchantmentRecipe wrapper, IIngredients ingredients) {
        IGuiItemStackGroup group = layout.getItemStacks();
        group.init(0, true, 0, 0);
        ItemStack stack = new ItemStack((IItemProvider)wrapper.getAbstractTool());
        StackUtils.setMaterial(stack, wrapper.getMaterial());
        group.set(0, stack);
        group.init(1, true, 18, 0);
        ItemStack stack1 = new ItemStack((IItemProvider)ModItems.ENCHANTMENT);
        ModItems.ENCHANTMENT.setEnchantment(stack1, wrapper.getEnchantment().field_76302_b, wrapper.getEnchantment().field_76303_c);
        group.set(1, stack1);
        group.init(2, true, 36, 0);
        group.init(3, true, 0, 18);
        group.init(4, true, 18, 18);
        group.init(5, true, 36, 18);
        group.init(6, true, 0, 36);
        group.init(7, true, 18, 36);
        group.init(8, true, 36, 36);
        group.init(9, false, 94, 18);
        group.set(9, wrapper.getAbstractTool().applyEnchantment(stack, stack1));
    }
}

