/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.items.enchantments;

import de.maxhenkel.advancedtools.ModCreativeTabs;
import de.maxhenkel.advancedtools.items.tools.StackUtils;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemEnchantmentRemover
extends Item {
    public ItemEnchantmentRemover() {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.TAB_ADVANCED_TOOLS));
        this.setRegistryName(new ResourceLocation("advancedtools", "enchantment_remover"));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new TranslationTextComponent("tooltip.enchantment_remover", new Object[0]).func_211708_a(TextFormatting.GRAY));
        Enchantment data = this.getEnchantment(stack);
        if (data != null) {
            tooltip.add(new TranslationTextComponent(data.func_77320_a(), new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        Enchantment enchantment = this.getEnchantment(stack);
        Iterator iterator = ForgeRegistries.ENCHANTMENTS.iterator();
        while (iterator.hasNext()) {
            Enchantment e = (Enchantment)iterator.next();
            if (enchantment == null) {
                this.applyEnchantment(playerIn, stack, e);
                break;
            }
            if (!e.equals(enchantment)) continue;
            if (!iterator.hasNext() && !(iterator = ForgeRegistries.ENCHANTMENTS.iterator()).hasNext()) break;
            e = (Enchantment)iterator.next();
            this.applyEnchantment(playerIn, stack, e);
            break;
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
    }

    private void applyEnchantment(PlayerEntity player, ItemStack stack, Enchantment e) {
        this.setEnchantment(stack, e);
        player.func_146105_b((ITextComponent)new TranslationTextComponent("statusbar.enchantment_remover", new Object[]{new TranslationTextComponent(e.func_77320_a(), new Object[0])}), true);
    }

    public void setEnchantment(ItemStack stack, Enchantment enchantment) {
        CompoundNBT compound = StackUtils.getStackCompound(stack);
        compound.func_74778_a("enchantment", enchantment.getRegistryName().toString());
    }

    public Enchantment getEnchantment(ItemStack stack) {
        CompoundNBT compound = StackUtils.getStackCompound(stack);
        if (!compound.func_74764_b("enchantment")) {
            return null;
        }
        String name = compound.func_74779_i("enchantment");
        if (name == null) {
            return null;
        }
        String[] split = name.split(":");
        if (split.length < 2) {
            return null;
        }
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(split[0], split[1]));
    }
}

