/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.items.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.maxhenkel.advancedtools.items.tools.AbstractTool;
import de.maxhenkel.advancedtools.items.tools.AdvancedToolMaterial;
import de.maxhenkel.advancedtools.items.tools.StackUtils;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;

public class AdvancedPickaxe
extends AbstractTool {
    private static final Set<Material> EFFECTIVE_ON = Sets.newHashSet((Object[])new Material[]{Material.field_151574_g, Material.field_151588_w, Material.field_151573_f, Material.field_151598_x, Material.field_151576_e});
    private static final ImmutableList<Enchantment> VALID_ENCHANTMENTS = ImmutableList.of((Object)Enchantments.field_185305_q, (Object)Enchantments.field_185308_t, (Object)Enchantments.field_185306_r, (Object)Enchantments.field_185307_s, (Object)Enchantments.field_185296_A);

    public AdvancedPickaxe() {
        this.setRegistryName(new ResourceLocation("advancedtools", "pickaxe"));
    }

    @Override
    public Set<ToolType> getToolTypes(ItemStack stack) {
        return ImmutableSet.of((Object)ToolType.PICKAXE);
    }

    @Override
    public float getAttackDamage(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return mat.getAttackModifier();
        }
        return 0.0f;
    }

    @Override
    public float getAttackSpeed(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return -2.8f;
        }
        return 0.0f;
    }

    @Override
    public float getEfficiency(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return mat.getEfficiency();
        }
        return 1.0f;
    }

    @Override
    public Set<Material> getEffectiveMaterials(ItemStack stack) {
        return EFFECTIVE_ON;
    }

    @Override
    public int getHarvestLevel(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return mat.getHarvestLevel();
        }
        return 0;
    }

    @Override
    public String getPrimaryToolType() {
        return "pickaxe";
    }

    @Override
    public ImmutableList<Enchantment> getValidEnchantments(ItemStack stack) {
        return VALID_ENCHANTMENTS;
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return mat.getMaxDamage();
        }
        return 0;
    }

    @Override
    public int getRepairCost(ItemStack stack) {
        return 3;
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        int i = this.func_200891_e().func_200925_d();
        if (state.getHarvestTool() == ToolType.PICKAXE) {
            return i >= state.getHarvestLevel();
        }
        Material material = state.func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g;
    }
}

