/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.items.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.maxhenkel.advancedtools.items.tools.AbstractTool;
import de.maxhenkel.advancedtools.items.tools.AdvancedToolMaterial;
import de.maxhenkel.advancedtools.items.tools.StackUtils;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;

public class AdvancedShovel
extends AbstractTool {
    private static final Set<Material> EFFECTIVE_ON = Sets.newHashSet((Object[])new Material[]{Material.field_151571_B, Material.field_151597_y, Material.field_151596_z, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y});
    private static final ImmutableList<Enchantment> VALID_ENCHANTMENTS = ImmutableList.of((Object)Enchantments.field_185305_q, (Object)Enchantments.field_185308_t, (Object)Enchantments.field_185306_r, (Object)Enchantments.field_185307_s, (Object)Enchantments.field_185296_A);

    public AdvancedShovel() {
        this.setRegistryName(new ResourceLocation("advancedtools", "shovel"));
    }

    @Override
    public Set<ToolType> getToolTypes(ItemStack stack) {
        return ImmutableSet.of((Object)ToolType.SHOVEL);
    }

    @Override
    public float getAttackDamage(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return mat.getAttackModifier();
        }
        return 0.0f;
    }

    @Override
    public float getAttackSpeed(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return -3.0f;
        }
        return 0.0f;
    }

    @Override
    public float getEfficiency(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return mat.getEfficiency();
        }
        return 1.0f;
    }

    @Override
    public Set<Material> getEffectiveMaterials(ItemStack stack) {
        return EFFECTIVE_ON;
    }

    @Override
    public int getHarvestLevel(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return mat.getHarvestLevel();
        }
        return 0;
    }

    @Override
    public String getPrimaryToolType() {
        return "shovel";
    }

    @Override
    public ImmutableList<Enchantment> getValidEnchantments(ItemStack stack) {
        return VALID_ENCHANTMENTS;
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return mat.getMaxDamage();
        }
        return 0;
    }

    @Override
    public int getRepairCost(ItemStack stack) {
        return 1;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (this.isBroken(context.func_195996_i())) {
            return ActionResultType.PASS;
        }
        ActionResultType result = Items.field_151047_v.func_195939_a(context);
        if (result.equals((Object)ActionResultType.SUCCESS)) {
            StackUtils.incrementToolStat(context.func_195996_i(), StackUtils.Stat.STAT_PATHS_CREATED, 1);
        }
        return result;
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_196604_cC || block == Blocks.field_150433_aE;
    }
}

