/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.items.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Blocks;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AdvancedToolMaterial {
    public static final String PICKAXE = "pickaxe";
    public static final String AXE = "axe";
    public static final String SWORD = "sword";
    public static final String SHOVEL = "shovel";
    public static final String HOE = "hoe";
    private static Map<String, AdvancedToolMaterial> materials = new HashMap<String, AdvancedToolMaterial>();
    public static final AdvancedToolMaterial DIAMOND = new AdvancedToolMaterial("diamond", 8.0f, 3.0f, 3, 2048, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151045_i}));
    public static final AdvancedToolMaterial IRON;
    public static final AdvancedToolMaterial GOLD;
    public static final AdvancedToolMaterial WOOD;
    public static final AdvancedToolMaterial STONE;
    private String name;
    private float efficiency;
    private float attackModifier;
    private int harvestLevel;
    private int maxDamage;
    private Supplier<Ingredient> ingredient;

    public AdvancedToolMaterial(String name, float efficiency, float attackModifier, int harvestLevel, int maxDamage, Supplier<Ingredient> ingredient) {
        this.name = name;
        this.efficiency = efficiency;
        this.attackModifier = attackModifier;
        this.harvestLevel = harvestLevel;
        this.maxDamage = maxDamage;
        this.ingredient = ingredient;
    }

    public float getEfficiency() {
        return this.efficiency;
    }

    public float getAttackModifier() {
        return this.attackModifier;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    public String getName() {
        return this.name;
    }

    public Ingredient getIngredient() {
        return this.ingredient.get();
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent("material." + this.name, new Object[0]);
    }

    public static AdvancedToolMaterial byName(String name) {
        if (name == null) {
            return null;
        }
        return materials.get(name);
    }

    public static Collection<AdvancedToolMaterial> getAll() {
        return Collections.unmodifiableCollection(materials.values());
    }

    static {
        materials.put("diamond", DIAMOND);
        IRON = new AdvancedToolMaterial("iron", 6.0f, 2.0f, 2, 256, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j}));
        materials.put("iron", IRON);
        GOLD = new AdvancedToolMaterial("gold", 12.0f, 0.0f, 0, 32, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151043_k}));
        materials.put("gold", GOLD);
        STONE = new AdvancedToolMaterial("stone", 4.0f, 1.0f, 1, 128, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150347_e}));
        materials.put("stone", STONE);
        WOOD = new AdvancedToolMaterial("wood", 2.0f, 0.0f, 0, 64, () -> Ingredient.func_199805_a((Tag)ItemTags.field_199905_b));
        materials.put("wood", WOOD);
    }
}

