/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.crafting;

import com.google.gson.JsonObject;
import de.maxhenkel.advancedtools.Main;
import de.maxhenkel.advancedtools.items.tools.AdvancedToolMaterial;
import de.maxhenkel.advancedtools.items.tools.StackUtils;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeToolMaterial
implements ICraftingRecipe,
IShapedRecipe<CraftingInventory> {
    private ShapedRecipe recipe;
    private AdvancedToolMaterial material;

    public RecipeToolMaterial(ShapedRecipe recipe, AdvancedToolMaterial material) {
        this.recipe = recipe;
        this.material = material;
    }

    public int getRecipeWidth() {
        return this.recipe.getRecipeWidth();
    }

    public int getRecipeHeight() {
        return this.recipe.getRecipeHeight();
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return this.recipe.func_77569_a(inv, worldIn);
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        return StackUtils.setMaterial(this.recipe.func_77572_b(inv), this.material);
    }

    public boolean func_194133_a(int width, int height) {
        return this.recipe.func_194133_a(width, height);
    }

    public ItemStack func_77571_b() {
        return StackUtils.setMaterial(this.recipe.func_77571_b(), this.material);
    }

    public ResourceLocation func_199560_c() {
        return this.recipe.func_199560_c();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Main.CRAFTING_TOOL_MATERIAL;
    }

    public AdvancedToolMaterial getMaterial() {
        return this.material;
    }

    public ShapedRecipe getRecipe() {
        return this.recipe;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.recipe.func_192400_c();
    }

    public static class RecipeToolMaterialSerializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeToolMaterial> {
        private ShapedRecipe.Serializer serializer = new ShapedRecipe.Serializer();

        public RecipeToolMaterial read(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return new RecipeToolMaterial(this.serializer.func_199425_a_(resourceLocation, jsonObject), AdvancedToolMaterial.byName(jsonObject.get("result").getAsJsonObject().get("material").getAsString()));
        }

        public RecipeToolMaterial read(ResourceLocation resourceLocation, PacketBuffer packetBuffer) {
            String material = packetBuffer.func_218666_n();
            return new RecipeToolMaterial(this.serializer.func_199426_a_(resourceLocation, packetBuffer), AdvancedToolMaterial.byName(material));
        }

        public void write(PacketBuffer packetBuffer, RecipeToolMaterial recipe) {
            packetBuffer.func_180714_a(recipe.getMaterial().getName());
            this.serializer.func_199427_a_(packetBuffer, recipe.getRecipe());
        }
    }
}

