/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.integration.jei;

import de.maxhenkel.advancedtools.ModItems;
import de.maxhenkel.advancedtools.crafting.RecipeConvertTool;
import de.maxhenkel.advancedtools.crafting.RecipeToolMaterial;
import de.maxhenkel.advancedtools.integration.jei.ConvertToolExtension;
import de.maxhenkel.advancedtools.integration.jei.CraftToolExtension;
import de.maxhenkel.advancedtools.integration.jei.category.apply_enchantment.ApplyEnchantmentRecipeCategory;
import de.maxhenkel.advancedtools.integration.jei.category.apply_enchantment.EnchantmentRecipe;
import de.maxhenkel.advancedtools.integration.jei.category.combine_enchantment.CombineEnchantmentRecipeCategory;
import de.maxhenkel.advancedtools.integration.jei.category.convert_book.ConvertBookRecipe;
import de.maxhenkel.advancedtools.integration.jei.category.convert_book.ConvertBookRecipeCategory;
import de.maxhenkel.advancedtools.integration.jei.category.convert_enchantment.ConvertEnchantmentRecipeCategory;
import de.maxhenkel.advancedtools.integration.jei.category.remove_enchantment.EnchantmentRemoveRecipe;
import de.maxhenkel.advancedtools.integration.jei.category.remove_enchantment.RemoveEnchantmentRecipeCategory;
import de.maxhenkel.advancedtools.integration.jei.category.split_enchantment.SplitEnchantmentRecipeCategory;
import de.maxhenkel.advancedtools.integration.jei.category.upgrade.UpgradeRecipe;
import de.maxhenkel.advancedtools.integration.jei.category.upgrade.UpgradeRecipeCategory;
import de.maxhenkel.advancedtools.items.tools.AbstractTool;
import de.maxhenkel.advancedtools.items.tools.AdvancedToolMaterial;
import de.maxhenkel.advancedtools.items.tools.StackUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IExtendableRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation CATEGORY_ENCHANT = new ResourceLocation("advancedtools", "advancedtools.enchant");
    public static final ResourceLocation CATEGORY_UPGRADE = new ResourceLocation("advancedtools", "advancedtools.upgrade");
    public static final ResourceLocation CATEGORY_REMOVE_ENCHANTING = new ResourceLocation("advancedtools", "advancedtools.remove_enchanting");
    public static final ResourceLocation CATEGORY_BOOK_CONVERTING = new ResourceLocation("advancedtools", "advancedtools.book_converting");
    public static final ResourceLocation CATEGORY_ENCHANTMENT_CONVERTING = new ResourceLocation("advancedtools", "advancedtools.enchantment_converting");
    public static final ResourceLocation CATEGORY_ENCHANTMENT_COMBINING = new ResourceLocation("advancedtools", "advancedtools.enchantment_combining");
    public static final ResourceLocation CATEGORY_ENCHANTMENT_SPLITTING = new ResourceLocation("advancedtools", "advancedtools.enchantment_splitting");
    private static final ISubtypeInterpreter MATERIAL_SUBTYPE_INTERPRETER = itemStack -> StackUtils.getMaterial(itemStack).getName();

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.PICKAXE, MATERIAL_SUBTYPE_INTERPRETER);
        registration.registerSubtypeInterpreter((Item)ModItems.AXE, MATERIAL_SUBTYPE_INTERPRETER);
        registration.registerSubtypeInterpreter((Item)ModItems.SHOVEL, MATERIAL_SUBTYPE_INTERPRETER);
        registration.registerSubtypeInterpreter((Item)ModItems.SWORD, MATERIAL_SUBTYPE_INTERPRETER);
        registration.registerSubtypeInterpreter((Item)ModItems.HOE, MATERIAL_SUBTYPE_INTERPRETER);
        registration.registerSubtypeInterpreter((Item)ModItems.ENCHANTMENT, itemStack -> {
            EnchantmentData data = ModItems.ENCHANTMENT.getEnchantment(itemStack);
            if (data == null) {
                return "";
            }
            return data.field_76302_b.getRegistryName().toString() + ":" + data.field_76303_c;
        });
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.ENCHANTMENT), new ResourceLocation[]{CATEGORY_ENCHANT});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.ENCHANTMENT_REMOVER), new ResourceLocation[]{CATEGORY_REMOVE_ENCHANTING});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.ENCHANTMENT), new ResourceLocation[]{CATEGORY_BOOK_CONVERTING});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.ENCHANTMENT), new ResourceLocation[]{CATEGORY_ENCHANTMENT_COMBINING});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Items.field_151134_bR), new ResourceLocation[]{CATEGORY_ENCHANTMENT_CONVERTING});
        for (AbstractTool tool : ModItems.getAllTools()) {
            ItemStack stack = new ItemStack((IItemProvider)tool);
            StackUtils.setMaterial(stack, AdvancedToolMaterial.DIAMOND);
            registry.addRecipeCatalyst((Object)stack, new ResourceLocation[]{CATEGORY_UPGRADE});
        }
    }

    public void registerRecipes(IRecipeRegistration registry) {
        Iterator iterator = ForgeRegistries.ENCHANTMENTS.iterator();
        ArrayList allEnchantments = new ArrayList();
        Random r = new Random();
        while (iterator.hasNext()) {
            allEnchantments.add(iterator.next());
        }
        ArrayList<EnchantmentRecipe> enchants = new ArrayList<EnchantmentRecipe>();
        for (AbstractTool abstractTool : ModItems.getAllTools()) {
            for (AdvancedToolMaterial advancedToolMaterial : AdvancedToolMaterial.getAll()) {
                for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
                    for (int j = 1; j <= enchantment.func_77325_b(); ++j) {
                        ItemStack stack = new ItemStack((IItemProvider)abstractTool);
                        ItemStack ench = new ItemStack((IItemProvider)ModItems.ENCHANTMENT);
                        ModItems.ENCHANTMENT.setEnchantment(ench, enchantment, j);
                        if (abstractTool.applyEnchantment(stack, ench).func_190926_b()) continue;
                        enchants.add(new EnchantmentRecipe(new EnchantmentData(enchantment, j), abstractTool, advancedToolMaterial));
                    }
                }
            }
        }
        registry.addRecipes(enchants, CATEGORY_ENCHANT);
        ArrayList<EnchantmentRemoveRecipe> remove = new ArrayList<EnchantmentRemoveRecipe>();
        for (AbstractTool abstractTool : ModItems.getAllTools()) {
            for (AdvancedToolMaterial material : AdvancedToolMaterial.getAll()) {
                for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
                    for (int j = 1; j <= enchantment.func_77325_b(); ++j) {
                        ItemStack stack = new ItemStack((IItemProvider)abstractTool);
                        StackUtils.addEnchantment(stack, enchantment, j);
                        ItemStack ench = new ItemStack((IItemProvider)ModItems.ENCHANTMENT_REMOVER);
                        ModItems.ENCHANTMENT_REMOVER.setEnchantment(ench, enchantment);
                        if (abstractTool.removeEnchantment(stack, ench).func_190926_b()) continue;
                        remove.add(new EnchantmentRemoveRecipe(new EnchantmentData(enchantment, enchantment.func_77325_b()), abstractTool, material));
                    }
                }
            }
        }
        registry.addRecipes(remove, CATEGORY_REMOVE_ENCHANTING);
        ArrayList<ConvertBookRecipe> arrayList = new ArrayList<ConvertBookRecipe>();
        for (Enchantment enchantment : allEnchantments) {
            for (int j = 1; j <= enchantment.func_77325_b(); ++j) {
                EnchantmentData[] enchs = new EnchantmentData[r.nextInt(8) + 1];
                enchs[0] = new EnchantmentData(enchantment, j);
                for (int i = 1; i < enchs.length; ++i) {
                    Enchantment re = (Enchantment)allEnchantments.get(r.nextInt(allEnchantments.size()));
                    enchs[i] = new EnchantmentData(re, r.nextInt(re.func_77325_b()) + 1);
                }
                arrayList.add(new ConvertBookRecipe(enchs));
            }
        }
        registry.addRecipes(arrayList, CATEGORY_BOOK_CONVERTING);
        ArrayList<UpgradeRecipe> arrayList2 = new ArrayList<UpgradeRecipe>();
        for (AbstractTool tool : ModItems.getAllTools()) {
            for (AdvancedToolMaterial material : AdvancedToolMaterial.getAll()) {
                for (AdvancedToolMaterial material1 : AdvancedToolMaterial.getAll()) {
                    if (material.equals(material1)) continue;
                    arrayList2.add(new UpgradeRecipe(tool, material, material1));
                }
            }
        }
        registry.addRecipes(arrayList2, CATEGORY_UPGRADE);
        ArrayList<EnchantmentData> arrayList3 = new ArrayList<EnchantmentData>();
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            if (enchantment.func_77325_b() < 2) continue;
            for (int j = 2; j <= enchantment.func_77325_b(); ++j) {
                arrayList3.add(new EnchantmentData(enchantment, j));
            }
        }
        registry.addRecipes(arrayList3, CATEGORY_ENCHANTMENT_COMBINING);
        ArrayList<EnchantmentData> splitEnchantments = new ArrayList<EnchantmentData>();
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            for (int i = 2; i <= enchantment.func_77325_b(); ++i) {
                splitEnchantments.add(new EnchantmentData(enchantment, i));
            }
        }
        registry.addRecipes(splitEnchantments, CATEGORY_ENCHANTMENT_SPLITTING);
        ArrayList<EnchantmentData> ed = new ArrayList<EnchantmentData>();
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            for (int j = 1; j <= enchantment.func_77325_b(); ++j) {
                ed.add(new EnchantmentData(enchantment, j));
            }
        }
        registry.addRecipes(ed, CATEGORY_ENCHANTMENT_CONVERTING);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        IExtendableRecipeCategory craftingCategory = registration.getCraftingCategory();
        craftingCategory.addCategoryExtension(RecipeConvertTool.class, ConvertToolExtension::new);
        craftingCategory.addCategoryExtension(RecipeToolMaterial.class, CraftToolExtension::new);
    }

    private <T extends IRecipe> List<T> getAllRecipes(Class<T> clazz) {
        ArrayList<IRecipe> convertRecipes = new ArrayList<IRecipe>();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        RecipeManager recipeManager = world.func_199532_z();
        Collection recipes = recipeManager.func_199510_b();
        for (IRecipe recipe : recipes) {
            if (!recipe.getClass().isAssignableFrom(clazz)) continue;
            convertRecipes.add(recipe);
        }
        return convertRecipes;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new ApplyEnchantmentRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new RemoveEnchantmentRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new UpgradeRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ConvertBookRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CombineEnchantmentRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SplitEnchantmentRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ConvertEnchantmentRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("advancedtools", "advancedtools");
    }
}

