/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.items.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.maxhenkel.advancedtools.items.tools.AbstractTool;
import de.maxhenkel.advancedtools.items.tools.AdvancedToolMaterial;
import de.maxhenkel.advancedtools.items.tools.StackUtils;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;

public class AdvancedSword
extends AbstractTool {
    private static final Set<Material> EFFECTIVE_ON = Sets.newHashSet((Object[])new Material[]{Material.field_151569_G, Material.field_151572_C, Material.field_215713_z});
    private static final ImmutableList<Enchantment> VALID_ENCHANTMENTS = ImmutableList.of((Object)Enchantments.field_185307_s, (Object)Enchantments.field_185302_k, (Object)Enchantments.field_185303_l, (Object)Enchantments.field_180312_n, (Object)Enchantments.field_185296_A, (Object)Enchantments.field_180313_o, (Object)Enchantments.field_77334_n, (Object)Enchantments.field_191530_r, (Object)Enchantments.field_185304_p);

    public AdvancedSword() {
        this.setRegistryName(new ResourceLocation("advancedtools", "sword"));
    }

    @Override
    public Set<ToolType> getToolTypes(ItemStack stack) {
        return ImmutableSet.of((Object)ToolType.get((String)"sword"));
    }

    @Override
    public boolean countBreakStats(ItemStack stack) {
        return false;
    }

    @Override
    public float getAttackDamage(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return mat.getAttackModifier() + 3.0f;
        }
        return 0.0f;
    }

    @Override
    public float getAttackSpeed(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return -2.0f;
        }
        return 0.0f;
    }

    @Override
    public float getEfficiency(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return mat.getEfficiency();
        }
        return 1.0f;
    }

    @Override
    public Set<Material> getEffectiveMaterials(ItemStack stack) {
        return EFFECTIVE_ON;
    }

    @Override
    public int getHarvestLevel(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return mat.getHarvestLevel();
        }
        return 0;
    }

    @Override
    public String getPrimaryToolType() {
        return "sword";
    }

    @Override
    public ImmutableList<Enchantment> getValidEnchantments(ItemStack stack) {
        return VALID_ENCHANTMENTS;
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return mat.getMaxDamage();
        }
        return 0;
    }

    @Override
    public int getRepairCost(ItemStack stack, AdvancedToolMaterial material) {
        return material == AdvancedToolMaterial.NETHERITE ? 1 : 2;
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return state.func_177230_c() == Blocks.field_196553_aF;
    }
}

