/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.items.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.Tags;

public class AdvancedToolMaterial {
    public static final String PICKAXE = "pickaxe";
    public static final String AXE = "axe";
    public static final String SWORD = "sword";
    public static final String SHOVEL = "shovel";
    public static final String HOE = "hoe";
    private static Map<String, AdvancedToolMaterial> materials = new HashMap<String, AdvancedToolMaterial>();
    public static final AdvancedToolMaterial NETHERITE = new AdvancedToolMaterial("netherite", 9.0f, 4.0f, 4, 2048, true, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_234759_km_}));
    public static final AdvancedToolMaterial DIAMOND;
    public static final AdvancedToolMaterial IRON;
    public static final AdvancedToolMaterial GOLD;
    public static final AdvancedToolMaterial WOOD;
    public static final AdvancedToolMaterial STONE;
    private String name;
    private float efficiency;
    private float attackModifier;
    private int harvestLevel;
    private int maxDamage;
    private boolean fireResistant;
    private Supplier<Ingredient> ingredient;

    public AdvancedToolMaterial(String name, float efficiency, float attackModifier, int harvestLevel, int maxDamage, boolean fireResistant, Supplier<Ingredient> ingredient) {
        this.name = name;
        this.efficiency = efficiency;
        this.attackModifier = attackModifier;
        this.harvestLevel = harvestLevel;
        this.maxDamage = maxDamage;
        this.fireResistant = fireResistant;
        this.ingredient = ingredient;
    }

    public float getEfficiency() {
        return this.efficiency;
    }

    public float getAttackModifier() {
        return this.attackModifier;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFireResistant() {
        return this.fireResistant;
    }

    public Ingredient getIngredient() {
        return this.ingredient.get();
    }

    public IFormattableTextComponent getDisplayName() {
        return new TranslationTextComponent("material." + this.name);
    }

    public static AdvancedToolMaterial byName(String name) {
        if (name == null) {
            return null;
        }
        return materials.get(name);
    }

    public static Collection<AdvancedToolMaterial> getAll() {
        return Collections.unmodifiableCollection(materials.values());
    }

    static {
        materials.put("netherite", NETHERITE);
        DIAMOND = new AdvancedToolMaterial("diamond", 8.0f, 3.0f, 3, 1024, false, () -> Ingredient.func_199805_a((ITag)Tags.Items.GEMS_DIAMOND));
        materials.put("diamond", DIAMOND);
        IRON = new AdvancedToolMaterial("iron", 6.0f, 2.0f, 2, 256, false, () -> Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_IRON));
        materials.put("iron", IRON);
        GOLD = new AdvancedToolMaterial("gold", 12.0f, 0.0f, 0, 32, false, () -> Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_GOLD));
        materials.put("gold", GOLD);
        STONE = new AdvancedToolMaterial("stone", 4.0f, 1.0f, 1, 128, false, () -> Ingredient.func_199805_a((ITag)ItemTags.field_232909_aa_));
        materials.put("stone", STONE);
        WOOD = new AdvancedToolMaterial("wood", 2.0f, 0.0f, 0, 64, false, () -> Ingredient.func_199805_a((ITag)ItemTags.field_199905_b));
        materials.put("wood", WOOD);
    }
}

