/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.items.tools;

import com.google.common.collect.ImmutableList;
import de.maxhenkel.advancedtools.items.tools.AdvancedToolMaterial;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class StackUtils {
    private static final String TAG_MATERIAL = "Material";
    private static final String TAG_STATS = "Stats";
    private static final String TAG_TOOL_DATA = "ToolData";

    public static void addEnchantment(ItemStack stack, Enchantment enchantment, int level) {
        stack.func_77966_a(enchantment, level);
    }

    public static void updateFlags(ItemStack stack) {
        CompoundNBT compound = StackUtils.getStackCompound(stack);
        if (!compound.func_74764_b("HideFlags")) {
            compound.func_74768_a("HideFlags", 0);
        }
        compound.func_74768_a("HideFlags", compound.func_74762_e("HideFlags") | 1);
    }

    public static AdvancedToolMaterial getMaterial(ItemStack stack) {
        return AdvancedToolMaterial.byName(StackUtils.getStackToolData(stack).func_74779_i(TAG_MATERIAL));
    }

    public static ItemStack setMaterial(ItemStack stack, AdvancedToolMaterial material) {
        CompoundNBT toolData = StackUtils.getStackToolData(stack);
        toolData.func_74778_a(TAG_MATERIAL, material.getName());
        return stack;
    }

    public static void incrementToolStat(ItemStack stack, Stat stat, int amount) {
        CompoundNBT statTag = StackUtils.getStatTag(stack);
        if (!statTag.func_74764_b(stat.getNbtName())) {
            statTag.func_74768_a(stat.getNbtName(), amount);
        } else {
            int count = statTag.func_74762_e(stat.getNbtName());
            statTag.func_74768_a(stat.getNbtName(), count += amount);
        }
    }

    public static int getToolStat(ItemStack stack, Stat stat) {
        CompoundNBT statTag = StackUtils.getStatTag(stack);
        if (statTag.func_74764_b(stat.getNbtName())) {
            return statTag.func_74762_e(stat.getNbtName());
        }
        return 0;
    }

    public static Map<Stat, Integer> getToolStats(ItemStack stack) {
        HashMap<Stat, Integer> stats = new HashMap<Stat, Integer>();
        CompoundNBT statTag = StackUtils.getStatTag(stack);
        Set keys = statTag.func_150296_c();
        for (String key : keys) {
            Stat stat = Stat.getStatFromNBTName(key);
            if (stat == null) continue;
            stats.put(stat, statTag.func_74762_e(key));
        }
        return stats;
    }

    private static CompoundNBT getStatTag(ItemStack stack) {
        CompoundNBT td = StackUtils.getStackToolData(stack);
        if (!td.func_74764_b(TAG_STATS)) {
            td.func_218657_a(TAG_STATS, (INBT)new CompoundNBT());
        }
        return td.func_74775_l(TAG_STATS);
    }

    public static CompoundNBT getStackCompound(ItemStack stack) {
        return stack.func_196082_o();
    }

    public static CompoundNBT getStackToolData(ItemStack stack) {
        CompoundNBT compound = StackUtils.getStackCompound(stack);
        if (!compound.func_74764_b(TAG_TOOL_DATA)) {
            compound.func_218657_a(TAG_TOOL_DATA, (INBT)new CompoundNBT());
        }
        return compound.func_74775_l(TAG_TOOL_DATA);
    }

    public static class Stat {
        public static final Stat STAT_BLOCKS_MINED = new Stat("blocks_mined", "BlocksMined");
        public static final Stat STAT_MOBS_HIT = new Stat("mobs_hit", "MobsHit");
        public static final Stat STAT_HOED = new Stat("farmland_hoed", "FarmlandHoed");
        public static final Stat STAT_PATHS_CREATED = new Stat("paths_created", "PathsCreated");
        public static final Stat STAT_LOGS_STRIPPED = new Stat("logs_stripped", "LogsStripped");
        public static final List<Stat> STATS = ImmutableList.of((Object)STAT_BLOCKS_MINED, (Object)STAT_MOBS_HIT, (Object)STAT_HOED, (Object)STAT_PATHS_CREATED, (Object)STAT_LOGS_STRIPPED);
        private String nbtName;
        private String translationName;

        public Stat(String translationName, String nbtName) {
            this.nbtName = nbtName;
            this.translationName = translationName;
        }

        public String getNbtName() {
            return this.nbtName;
        }

        public String getTranslationName() {
            return "stat." + this.translationName;
        }

        public static Stat getStatFromNBTName(String name) {
            return STATS.stream().filter(stat -> stat.getNbtName().equals(name)).findAny().orElse(null);
        }

        public IFormattableTextComponent getTranslation(Object ... args) {
            return new TranslationTextComponent(this.getTranslationName(), args);
        }
    }
}

