/*
 * Decompiled with CFR 0.152.
 */
package shadows.deadly.asm;

import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import shadows.Apotheosis;
import shadows.deadly.config.DeadlyConfig;
import shadows.deadly.gen.WorldGenerator;
import shadows.deadly.loot.affix.Affix;
import shadows.deadly.loot.affix.AffixHelper;

public class DeadlyHooks {
    static Access access = new Access();

    public static void setDungeonMobSpawner(World world, BlockPos pos, Random rand) {
        if (!Apotheosis.enableDeadly) {
            return;
        }
        if (rand.nextFloat() <= DeadlyConfig.dungeonBrutalChance) {
            WorldGenerator.BRUTAL_SPAWNER.place(world, pos, rand);
        } else if (rand.nextFloat() <= DeadlyConfig.dungeonSwarmChance) {
            WorldGenerator.SWARM_SPAWNER.place(world, pos, rand);
        }
    }

    public static UUID getRealUUID(UUID uuid) {
        if (!Apotheosis.enableDeadly) {
            return uuid;
        }
        if (access.getADM().equals(uuid)) {
            return access.getADM();
        }
        if (access.getASM().equals(uuid)) {
            return access.getASM();
        }
        return uuid;
    }

    public static int getProtectionLevel(Iterable<ItemStack> stacks, DamageSource source) {
        int prot = 0;
        for (ItemStack s : stacks) {
            Map<Affix, Float> affixes = AffixHelper.getAffixes(s);
            for (Map.Entry<Affix, Float> e : affixes.entrySet()) {
                prot += e.getKey().getProtectionLevel(e.getValue().floatValue(), source);
            }
        }
        return prot;
    }

    public static float getExtraDamageFor(ItemStack stack, EnumCreatureAttribute type) {
        float dmg = 0.0f;
        Map<Affix, Float> affixes = AffixHelper.getAffixes(stack);
        for (Map.Entry<Affix, Float> e : affixes.entrySet()) {
            dmg += e.getKey().getExtraDamageFor(e.getValue().floatValue(), type);
        }
        return dmg;
    }

    public static void onEntityDamaged(EntityLivingBase user, Entity target) {
        if (user != null) {
            for (ItemStack s : user.func_184209_aF()) {
                Map<Affix, Float> affixes = AffixHelper.getAffixes(s);
                for (Map.Entry<Affix, Float> e : affixes.entrySet()) {
                    target.field_70172_ad = 0;
                    int old = 0;
                    e.getKey().onEntityDamaged(user, target, e.getValue().floatValue());
                    target.field_70172_ad = old;
                }
            }
        }
    }

    public static void onUserHurt(EntityLivingBase user, Entity attacker) {
        if (user != null) {
            for (ItemStack s : user.func_184209_aF()) {
                Map<Affix, Float> affixes = AffixHelper.getAffixes(s);
                for (Map.Entry<Affix, Float> e : affixes.entrySet()) {
                    e.getKey().onUserHurt(user, attacker, e.getValue().floatValue());
                }
            }
        }
    }

    private static class Access
    extends Item {
        private Access() {
        }

        public UUID getADM() {
            return Item.field_111210_e;
        }

        public UUID getASM() {
            return Item.field_185050_h;
        }
    }
}

