/*
 * Decompiled with CFR 0.152.
 */
package shadows.deadly.gen;

import com.google.common.base.Predicate;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import shadows.deadly.DeadlyModule;
import shadows.deadly.config.DeadlyConfig;
import shadows.deadly.gen.BossFeature;
import shadows.deadly.gen.BrutalSpawner;
import shadows.deadly.gen.SwarmSpawner;
import shadows.deadly.gen.WorldFeature;

public class WorldGenerator {
    public static final List<WorldFeature> FEATURES = new ArrayList<WorldFeature>();
    public static final BrutalSpawner BRUTAL_SPAWNER = new BrutalSpawner();
    public static final BossFeature BOSS_GENERATOR = new BossFeature();
    public static final SwarmSpawner SWARM_SPAWNER = new SwarmSpawner();
    private static final Int2ObjectMap<LongSet> SUCCESSES = new Int2ObjectOpenHashMap();
    public static final Predicate<IBlockState> STONE_TEST = s -> s.func_177230_c() == Blocks.field_150348_b && ((BlockStone.EnumType)s.func_177229_b((IProperty)BlockStone.field_176247_a)).func_190912_e();
    public static final boolean DEBUG = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");

    @SubscribeEvent
    public void terrainGen(PopulateChunkEvent.Pre e) {
        if (DeadlyConfig.DIM_WHITELIST.contains(e.getWorld().field_73011_w.getDimension())) {
            BlockPos pos = new BlockPos(e.getChunkX() << 4, 0, e.getChunkZ() << 4);
            if (DeadlyConfig.BIOME_BLACKLIST.contains(e.getWorld().func_180494_b(pos).getRegistryName())) {
                return;
            }
            for (WorldFeature feature : FEATURES) {
                if (WorldGenerator.wasSuccess(e.getWorld().field_73011_w.getDimension(), e.getChunkX(), e.getChunkZ())) {
                    return;
                }
                feature.generate(e.getWorld(), e.getChunkX(), e.getChunkZ(), e.getRand());
            }
        }
    }

    public static void init() {
        if (BRUTAL_SPAWNER.isEnabled()) {
            FEATURES.add(BRUTAL_SPAWNER);
        }
        if (SWARM_SPAWNER.isEnabled()) {
            FEATURES.add(SWARM_SPAWNER);
        }
        if (BOSS_GENERATOR.isEnabled()) {
            FEATURES.add(BOSS_GENERATOR);
        }
    }

    public static void debugPillar(World world, BlockPos pos) {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(pos);
        DeadlyModule.LOGGER.info("Marking! " + pos.toString());
        while (mPos.func_177956_o() < 127) {
            world.func_175656_a((BlockPos)mPos.func_181079_c(mPos.func_177958_n(), mPos.func_177956_o() + 1, mPos.func_177952_p()), Blocks.field_150359_w.func_176223_P());
        }
    }

    public static void debugLog(BlockPos pos, String name) {
        if (DEBUG) {
            DeadlyModule.LOGGER.info("Generated a {} at {} {} {}", (Object)name, (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
    }

    public static void setSuccess(int dim, int x, int z) {
        ((LongSet)SUCCESSES.computeIfAbsent((Object)dim, i -> new LongOpenHashSet())).add(ChunkPos.func_77272_a((int)x, (int)z));
    }

    public static boolean wasSuccess(int dim, int x, int z) {
        return ((LongSet)SUCCESSES.computeIfAbsent((Object)dim, i -> new LongOpenHashSet())).contains(ChunkPos.func_77272_a((int)x, (int)z));
    }
}

