/*
 * Decompiled with CFR 0.152.
 */
package shadows.deadly.loot.affix;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import shadows.deadly.loot.AffixModifier;

public abstract class Affix
extends WeightedRandom.Item
implements IForgeRegistryEntry<Affix> {
    public static final ForgeRegistry<Affix> REGISTRY;
    protected ResourceLocation name;
    protected final boolean prefix;

    public Affix(boolean prefix, int weight) {
        super(weight);
        this.prefix = prefix;
    }

    public boolean isPrefix() {
        return this.prefix;
    }

    public abstract float apply(ItemStack var1, Random var2, @Nullable AffixModifier var3);

    public ITextComponent chainName(ITextComponent name, @Nullable AffixModifier modifier) {
        return new TextComponentTranslation("affix." + this.name + (modifier != null && modifier.editName() ? "." + modifier.getKey() : ""), new Object[]{name});
    }

    public int getProtectionLevel(float level, DamageSource source) {
        return 0;
    }

    public float getExtraDamageFor(float level, EnumCreatureAttribute creatureType) {
        return 0.0f;
    }

    public void onEntityDamaged(EntityLivingBase user, @Nullable Entity target, float level) {
    }

    public void onUserHurt(EntityLivingBase user, @Nullable Entity attacker, float level) {
    }

    public Affix setRegistryName(ResourceLocation name) {
        if (this.name == null) {
            this.name = name;
        }
        return this;
    }

    public Affix setRegistryName(String name) {
        return this.setRegistryName(GameData.checkPrefix((String)name, (boolean)false));
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Class<Affix> getRegistryType() {
        return Affix.class;
    }

    public static void classload() {
    }

    static {
        RegistryBuilder build = new RegistryBuilder();
        build.setName(new ResourceLocation("apotheosis", "affixes"));
        build.setType(Affix.class);
        REGISTRY = (ForgeRegistry)build.create();
    }
}

