/*
 * Decompiled with CFR 0.152.
 */
package shadows.deadly.loot.affix;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import shadows.deadly.loot.affix.Affix;
import shadows.deadly.loot.affix.AffixHelper;
import shadows.deadly.loot.affix.Affixes;

public class AffixEvents {
    public static final List<ItemStack> NUGGETS = new ArrayList<ItemStack>();

    @SubscribeEvent
    public void crit(CriticalHitEvent e) {
        Map<Affix, Float> affixes = AffixHelper.getAffixes(e.getEntityPlayer().func_184614_ca());
        if (!e.isVanillaCritical() && affixes.containsKey((Object)Affixes.ALWAYS_CRIT)) {
            e.setResult(Event.Result.ALLOW);
        }
        if (affixes.containsKey((Object)Affixes.CRIT_DAMAGE)) {
            e.setDamageModifier(affixes.get((Object)Affixes.CRIT_DAMAGE).floatValue() + e.getDamageModifier());
        }
    }

    @SubscribeEvent
    public void harvest(BlockEvent.HarvestDropsEvent e) {
        if (e.getHarvester() == null) {
            return;
        }
        ItemStack stack = e.getHarvester().func_184614_ca();
        if (stack.func_190926_b() || !stack.func_77942_o() || !AffixEvents.isEffective(stack, e.getState())) {
            return;
        }
        Map<Affix, Float> affixes = AffixHelper.getAffixes(stack);
        if (affixes.containsKey((Object)Affixes.SIFTING) && e.getWorld().field_73012_v.nextFloat() <= affixes.get((Object)Affixes.SIFTING).floatValue()) {
            e.getDrops().add(NUGGETS.get(e.getWorld().field_73012_v.nextInt(NUGGETS.size())).func_77946_l());
        }
    }

    private static boolean isEffective(ItemStack stack, IBlockState state) {
        for (String s : stack.func_77973_b().getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(s, state)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void tick(TickEvent.PlayerTickEvent e) {
        Map<Affix, Float> affixes;
        EntityPlayer player = e.player;
        if (e.phase == TickEvent.Phase.END) {
            return;
        }
        ItemStack active = player.func_184607_cu();
        if (active.func_77973_b().isShield(active, (EntityLivingBase)player) && active.func_77942_o() && (affixes = AffixHelper.getAffixes(active)).containsKey((Object)Affixes.RESISTANCE)) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, (int)(affixes.get((Object)Affixes.RESISTANCE).floatValue() * 20.0f)));
        }
    }

    static {
        NUGGETS.add(new ItemStack(Items.field_151074_bl));
        NUGGETS.add(new ItemStack(Items.field_191525_da));
    }
}

