/*
 * Decompiled with CFR 0.152.
 */
package shadows.deadly.loot.affix.impl;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.storage.loot.RandomValueRange;
import shadows.deadly.gen.BossItem;
import shadows.deadly.loot.AffixModifier;
import shadows.deadly.loot.affix.Affix;

public class AttributeAffix
extends Affix {
    protected final IAttribute attr;
    protected final RandomValueRange range;
    protected final int op;
    protected final boolean reactive;

    public AttributeAffix(IAttribute attr, RandomValueRange range, int op, boolean prefix, int weight) {
        super(prefix, weight);
        this.attr = attr;
        this.range = range;
        this.op = op;
        this.reactive = attr instanceof IReactiveAttribute;
    }

    public AttributeAffix(IAttribute attr, float min, float max, int op, boolean prefix, int weight) {
        this(attr, new RandomValueRange(min, max), op, prefix, weight);
    }

    @Override
    public float apply(ItemStack stack, Random rand, @Nullable AffixModifier modifier) {
        EntityEquipmentSlot type = BossItem.EquipmentType.getTypeFor(stack).getSlot(stack);
        float lvl = this.range.func_186507_b(rand);
        if (modifier != null) {
            lvl = modifier.editLevel(lvl);
        }
        AttributeModifier modif = new AttributeModifier("affix_" + this.attr.func_111108_a(), (double)lvl, this.op);
        stack.func_185129_a(this.attr.func_111108_a(), modif, type);
        return lvl;
    }

    @Override
    public void onEntityDamaged(EntityLivingBase user, Entity target, float level) {
        if (this.reactive) {
            ((IReactiveAttribute)this.attr).onEntityDamaged(user, target, level);
        }
    }

    @Override
    public void onUserHurt(EntityLivingBase user, Entity attacker, float level) {
        if (this.reactive) {
            ((IReactiveAttribute)this.attr).onUserHurt(user, attacker, level);
        }
    }

    @Override
    public int getProtectionLevel(float level, DamageSource source) {
        if (this.reactive) {
            return ((IReactiveAttribute)this.attr).getProtectionLevel(level, source);
        }
        return super.getProtectionLevel(level, source);
    }

    @Override
    public float getExtraDamageFor(float level, EnumCreatureAttribute creatureType) {
        if (this.reactive) {
            return ((IReactiveAttribute)this.attr).getExtraDamageFor(level, creatureType);
        }
        return super.getExtraDamageFor(level, creatureType);
    }

    public static interface IReactiveAttribute
    extends IAttribute {
        default public void onEntityDamaged(EntityLivingBase user, Entity target, float level) {
        }

        default public void onUserHurt(EntityLivingBase user, Entity attacker, float level) {
        }

        default public int getProtectionLevel(float level, DamageSource source) {
            return 0;
        }

        default public float getExtraDamageFor(float level, EnumCreatureAttribute creatureType) {
            return 0.0f;
        }
    }
}

