/*
 * Decompiled with CFR 0.152.
 */
package shadows.ench.anvil;

import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shadows.ApotheosisObjects;
import shadows.ench.anvil.TileAnvil;
import shadows.ench.anvil.compat.InspirationsCompat;

public class BlockAnvilExt
extends BlockAnvil {
    boolean inspirations = Loader.isModLoaded((String)"inspirations");

    public BlockAnvilExt() {
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185858_k);
        this.func_149752_b(2000.0f);
        this.func_149663_c("anvil");
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAnvil();
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        ItemStack anvil = new ItemStack((Block)this, 1, this.func_180651_a(state));
        if (te instanceof TileAnvil) {
            TileAnvil anv = (TileAnvil)te;
            HashMap<Enchantment, Integer> ench = new HashMap<Enchantment, Integer>();
            if (anv.getUnbreaking() > 0) {
                ench.put(Enchantments.field_185307_s, anv.getUnbreaking());
            }
            if (anv.getSplitting() > 0) {
                ench.put(ApotheosisObjects.SPLITTING, anv.getSplitting());
            }
            EnchantmentHelper.func_82782_a(ench, (ItemStack)anvil);
        }
        BlockAnvilExt.func_180635_a((World)world, (BlockPos)pos, (ItemStack)anvil);
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileAnvil) {
            ((TileAnvil)te).setUnbreaking(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack));
            ((TileAnvil)te).setSplitting(EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.SPLITTING, (ItemStack)stack));
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (!stack.func_77962_s()) {
            tooltip.add(I18n.func_135052_a((String)"info.apotheosis.anvil", (Object[])new Object[0]));
        }
    }

    protected void func_149829_a(EntityFallingBlock e) {
        super.func_149829_a(e);
        TileEntity te = e.field_70170_p.func_175625_s(new BlockPos((Entity)e));
        if (te instanceof TileAnvil) {
            e.field_145810_d = new NBTTagCompound();
            te.func_189515_b(e.field_145810_d);
        }
    }

    public void func_176502_a_(World world, BlockPos pos, IBlockState fallState, IBlockState hitState) {
        if (this.inspirations) {
            InspirationsCompat.onEndFalling(world, pos, fallState, hitState);
        } else {
            super.func_176502_a_(world, pos, fallState, hitState);
        }
        List items = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)));
        EntityFallingBlock anvil = (EntityFallingBlock)world.func_72872_a(EntityFallingBlock.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1))).get(0);
        int split = anvil.field_145810_d.func_74762_e("splitting");
        int ub = anvil.field_145810_d.func_74762_e("ub");
        if (split > 0) {
            for (EntityItem entity : items) {
                ItemStack stack = entity.func_92059_d();
                if (stack.func_77973_b() != Items.field_151134_bR && !(stack.func_77973_b() instanceof ItemBook)) continue;
                if (world.field_73012_v.nextInt(Math.max(1, 6 - split)) == 0) {
                    NBTTagList enchants = ItemEnchantedBook.func_92110_g((ItemStack)stack);
                    if (stack.func_77973_b() instanceof ItemBook) {
                        enchants = stack.func_77986_q();
                    }
                    entity.func_70106_y();
                    for (NBTBase nbt : enchants) {
                        NBTTagCompound tag = (NBTTagCompound)nbt;
                        ItemStack book = ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(Enchantment.func_185262_c((int)tag.func_74762_e("id")), tag.func_74762_e("lvl")));
                        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)book);
                    }
                }
                if (world.field_73012_v.nextInt(1 + ub) != 0) break;
                int dmg = (Integer)fallState.func_177229_b((IProperty)BlockAnvil.field_176505_b) + 1;
                if (dmg > 2) {
                    world.func_175698_g(pos);
                    world.func_175718_b(1029, pos, 0);
                    break;
                }
                world.func_175656_a(pos, fallState.func_177226_a((IProperty)BlockAnvil.field_176505_b, (Comparable)Integer.valueOf(dmg)));
                break;
            }
        }
    }
}

