/*
 * Decompiled with CFR 0.152.
 */
package shadows.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import shadows.deadly.config.DeadlyConfig;
import shadows.placebo.util.SpawnerBuilder;

public class TagBuilder {
    public static final String HAND_ITEMS = "HandItems";
    public static final String ARMOR_ITEMS = "ArmorItems";
    public static final String PASSENGERS = "Passengers";
    public static final String PERSISTENT = "PersistenceRequired";
    public static final String HEALTH = "Health";
    public static final String OFFSET = "Offset";
    public static final String MOTION = "Motion";
    public static final String DIRECTION = "direction";
    public static final String ENTITY_FIRE = "Fire";
    public static final String ARROW_PICKUP = "pickup";
    public static final String ARROW_DAMAGE = "damage";
    public static final NBTTagCompound ARROW = TagBuilder.getDefaultTag(EntityTippedArrow.class);
    public static final String EFFECTS = "ActiveEffects";
    public static final String TIME = "Time";
    public static final String DROP_ITEM = "DropItem";
    public static final String HURT_ENTITIES = "HurtEntities";
    public static final String FALL_HURT_AMOUNT = "FallHurtAmount";
    public static final String FALL_HURT_MAX = "FallHurtMax";
    public static final String TILE_ENTITY_DATA = "TileEntityData";
    public static final NBTTagCompound TNT = TagBuilder.getDefaultTag(EntityTNTPrimed.class);
    public static final String FUSE = "Fuse";
    private static List<WeightedSpawnerEntity> randomPotentials = new ArrayList<WeightedSpawnerEntity>();

    public static NBTTagCompound getDefaultTag(Class<? extends Entity> entity) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("id", EntityList.func_191306_a(entity).toString());
        return tag;
    }

    public static NBTTagCompound setHealth(NBTTagCompound entity, float health) {
        entity.func_74776_a(HEALTH, health);
        return entity;
    }

    public static NBTTagCompound setPersistent(NBTTagCompound entity, boolean persistent) {
        entity.func_74757_a(PERSISTENT, persistent);
        return entity;
    }

    public static NBTTagCompound setEquipment(NBTTagCompound entity, ItemStack ... equipment) {
        ItemStack[] stacks = TagBuilder.fixStacks(equipment);
        NBTTagList tagListHands = new NBTTagList();
        for (int i = 0; i < 2; ++i) {
            tagListHands.func_74742_a((NBTBase)new NBTTagCompound());
        }
        NBTTagList tagListArmor = new NBTTagList();
        for (int i = 0; i < 4; ++i) {
            tagListArmor.func_74742_a((NBTBase)new NBTTagCompound());
        }
        for (EntityEquipmentSlot s : EntityEquipmentSlot.values()) {
            ItemStack stack = stacks[s.ordinal()];
            if (s.func_188453_a() == EntityEquipmentSlot.Type.HAND && !stack.func_190926_b()) {
                tagListHands.func_150304_a(s.func_188454_b(), (NBTBase)stack.func_77955_b(new NBTTagCompound()));
                continue;
            }
            if (stack.func_190926_b()) continue;
            tagListArmor.func_150304_a(s.func_188454_b(), (NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        entity.func_74782_a(HAND_ITEMS, (NBTBase)tagListHands);
        entity.func_74782_a(ARMOR_ITEMS, (NBTBase)tagListArmor);
        return entity;
    }

    private static ItemStack[] fixStacks(ItemStack[] unfixed) {
        ItemStack[] stacks = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
        for (int i = 0; i < unfixed.length; ++i) {
            if (unfixed[i] == null) continue;
            stacks[i] = unfixed[i];
        }
        return stacks;
    }

    public static NBTTagCompound setDropChances(NBTTagCompound entity, float ... chances) {
        float[] fixed = TagBuilder.fixChances(chances);
        NBTTagList tagListHands = new NBTTagList();
        NBTTagList tagListArmor = new NBTTagList();
        for (EntityEquipmentSlot s : EntityEquipmentSlot.values()) {
            NBTTagFloat chance = new NBTTagFloat(fixed[s.ordinal()]);
            if (s.func_188453_a() == EntityEquipmentSlot.Type.HAND) {
                tagListHands.func_150304_a(s.func_188454_b(), (NBTBase)chance);
                continue;
            }
            tagListArmor.func_150304_a(s.func_188454_b(), (NBTBase)chance);
        }
        entity.func_74782_a(HAND_ITEMS, (NBTBase)tagListHands);
        entity.func_74782_a(ARMOR_ITEMS, (NBTBase)tagListArmor);
        return entity;
    }

    private static float[] fixChances(float[] unfixed) {
        float[] chances = new float[6];
        for (int i = 0; i < unfixed.length; ++i) {
            chances[i] = unfixed[i];
        }
        return chances;
    }

    public static NBTTagCompound setOffset(NBTTagCompound entity, double x, double y, double z) {
        entity.func_74782_a(OFFSET, (NBTBase)TagBuilder.doubleTagList(x, y, z));
        return entity;
    }

    public static NBTTagCompound setMotion(NBTTagCompound entity, double x, double y, double z) {
        entity.func_74782_a(MOTION, (NBTBase)TagBuilder.doubleTagList(x, y, z));
        return entity;
    }

    public static NBTTagCompound setFireballMotion(NBTTagCompound entity, double x, double y, double z) {
        entity.func_74782_a(DIRECTION, (NBTBase)TagBuilder.doubleTagList(x, y, z));
        return entity;
    }

    public static NBTTagList doubleTagList(double ... data) {
        NBTTagList tagList = new NBTTagList();
        for (double d : data) {
            tagList.func_74742_a((NBTBase)new NBTTagDouble(d));
        }
        return tagList;
    }

    public static ItemStack addPotionEffect(ItemStack stack, Potion potion, int duration, int amplifier) {
        return PotionUtils.func_185184_a((ItemStack)stack, Arrays.asList(new PotionEffect(potion, duration, amplifier)));
    }

    public static void addPotionEffect(NBTTagCompound tag, Potion potion, int amplifier) {
        TagBuilder.addPotionEffect(tag, potion, Integer.MAX_VALUE, amplifier, false);
    }

    public static void addPotionEffect(NBTTagCompound tag, Potion potion, int amplifier, boolean showParticles) {
        TagBuilder.addPotionEffect(tag, potion, Integer.MAX_VALUE, amplifier, showParticles);
    }

    public static void addPotionEffect(NBTTagCompound tag, Potion potion, int duration, int amplifier) {
        TagBuilder.addPotionEffect(tag, potion, duration, amplifier, false);
    }

    public static NBTTagCompound addPotionEffect(NBTTagCompound entity, Potion potion, int duration, int amplifier, boolean showParticles) {
        NBTTagList effects = entity.func_150295_c(EFFECTS, 10);
        PotionEffect fx = new PotionEffect(potion, duration, amplifier, false, showParticles);
        effects.func_74742_a((NBTBase)fx.func_82719_a(new NBTTagCompound()));
        entity.func_74782_a(EFFECTS, (NBTBase)effects);
        return entity;
    }

    public static NBTTagCompound fallingBlock(IBlockState state, int time) {
        return TagBuilder.fallingBlock(state, time, false, 2.0f, 40, false, null);
    }

    public static NBTTagCompound fallingBlock(IBlockState state, int time, float fallDamage) {
        return TagBuilder.fallingBlock(state, time, true, fallDamage, 40, false, null);
    }

    public static NBTTagCompound fallingBlock(IBlockState state, int time, boolean hurtEntities, float fallDamage, int maxFallDamage, boolean dropItem, NBTTagCompound tileData) {
        NBTTagCompound tag = TagBuilder.getDefaultTag(EntityFallingBlock.class);
        tag.func_74778_a("Block", state.func_177230_c().getRegistryName().toString());
        tag.func_74774_a("Data", (byte)state.func_177230_c().func_176201_c(state));
        tag.func_74768_a(TIME, time);
        tag.func_74757_a(DROP_ITEM, dropItem);
        tag.func_74757_a(HURT_ENTITIES, hurtEntities);
        tag.func_74776_a(FALL_HURT_AMOUNT, fallDamage);
        tag.func_74768_a(FALL_HURT_MAX, maxFallDamage);
        if (tileData != null) {
            tag.func_74782_a(TILE_ENTITY_DATA, (NBTBase)tileData);
        }
        return tag;
    }

    public static SpawnerBuilder createMobSpawnerRandom() {
        if (randomPotentials.isEmpty()) {
            ArrayList<EntityEntry> valid = new ArrayList<EntityEntry>();
            for (EntityEntry e : ForgeRegistries.ENTITIES) {
                if (!IMob.class.isAssignableFrom(e.getEntityClass())) continue;
                valid.add(e);
            }
            for (EntityEntry e : valid) {
                NBTTagCompound tag = TagBuilder.getDefaultTag(e.getEntityClass());
                TagBuilder.checkForSkeleton(tag);
                int weight = DeadlyConfig.getWeightForEntry(e);
                if (weight <= 0) continue;
                randomPotentials.add(new WeightedSpawnerEntity(weight, tag));
            }
        }
        SpawnerBuilder sb = new SpawnerBuilder();
        sb.setPotentials(randomPotentials.toArray(new WeightedSpawnerEntity[0]));
        return sb;
    }

    public static WeightedSpawnerEntity getRandomEntity(Random rand) {
        return (WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)rand, randomPotentials);
    }

    public static NBTTagCompound applyTNTHat(NBTTagCompound tag) {
        TagBuilder.setMotion(tag, 0.0, 0.3, 0.0);
        TagBuilder.addPotionEffect(tag, MobEffects.field_76424_c, 1);
        TagBuilder.addPotionEffect(tag, MobEffects.field_76429_m, -6);
        TagBuilder.addPassengers(tag, TNT.func_74737_b());
        return tag;
    }

    public static NBTTagCompound addPassengers(NBTTagCompound entity, NBTTagCompound ... passengers) {
        NBTTagList list = entity.func_150295_c(PASSENGERS, 10);
        if (list.func_82582_d()) {
            entity.func_74782_a(PASSENGERS, (NBTBase)list);
        }
        for (NBTTagCompound nbt : passengers) {
            list.func_74742_a((NBTBase)nbt);
        }
        return entity;
    }

    public static NBTTagCompound checkForSkeleton(NBTTagCompound entity) {
        if (EntitySkeleton.class.isAssignableFrom(EntityList.getClass((ResourceLocation)new ResourceLocation(entity.func_74779_i("id"))))) {
            TagBuilder.setEquipment(entity, new ItemStack((Item)Items.field_151031_f));
        }
        return entity;
    }

    public static NBTTagCompound checkForCreeper(NBTTagCompound entity) {
        if (EntityCreeper.class.isAssignableFrom(EntityList.getClass((ResourceLocation)new ResourceLocation(entity.func_74779_i("id"))))) {
            NBTTagList effects = entity.func_150295_c(EFFECTS, 10);
            for (NBTBase nbt : effects) {
                ((NBTTagCompound)nbt).func_74768_a("Duration", 300);
            }
            return entity;
        }
        return entity;
    }
}

