/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.loot;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.conditions.SurvivesExplosion;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import shadows.placebo.Placebo;
import shadows.placebo.loot.PoolBuilder;
import shadows.placebo.loot.StackLootEntry;

public class LootSystem {
    private static final Map<ResourceLocation, LootTable> PLACEBO_TABLES = new HashMap<ResourceLocation, LootTable>();

    public static void registerLootTable(ResourceLocation key, LootTable table) {
        if (!PLACEBO_TABLES.containsKey(key)) {
            PLACEBO_TABLES.put(key, table);
        } else {
            Placebo.LOGGER.warn("Duplicate loot entry detected, this is not allowed!  Key: " + key);
        }
    }

    public static LootTable.Builder tableBuilder() {
        return new LootTable.Builder();
    }

    public static PoolBuilder poolBuilder(int minRolls, int maxRolls) {
        return new PoolBuilder(minRolls, maxRolls);
    }

    public static void defaultBlockTable(Block b) {
        LootTable.Builder builder = LootSystem.tableBuilder();
        builder.func_216040_a(LootSystem.poolBuilder(1, 1).addEntries(new LootEntry[]{new StackLootEntry(new ItemStack((IItemProvider)b))}).func_212840_b_(SurvivesExplosion.func_215968_b()));
        LootSystem.registerLootTable(new ResourceLocation(b.getRegistryName().func_110624_b(), "blocks/" + b.getRegistryName().func_110623_a()), builder.func_216038_b());
    }

    @SubscribeEvent
    public static void serverStart(FMLServerStartedEvent e) {
        SimpleReloadableResourceManager resMan = (SimpleReloadableResourceManager)e.getServer().func_195570_aG();
        Reloader rel = new Reloader();
        for (int i = 0; i < resMan.field_199015_d.size(); ++i) {
            if (!(resMan.field_199015_d.get(i) instanceof LootTableManager)) continue;
            resMan.field_199015_d.add(i + 1, rel);
            break;
        }
        rel.apply(PLACEBO_TABLES, null, null);
    }

    private static class Reloader
    extends ReloadListener<Map<ResourceLocation, LootTable>> {
        private Reloader() {
        }

        protected Map<ResourceLocation, LootTable> prepare(IResourceManager p_212854_1_, IProfiler p_212854_2_) {
            return PLACEBO_TABLES;
        }

        protected void apply(Map<ResourceLocation, LootTable> tables, IResourceManager manager, IProfiler profiler) {
            LootTableManager mgr = ServerLifecycleHooks.getCurrentServer().func_200249_aQ();
            mgr.field_186527_c = new HashMap(mgr.field_186527_c);
            tables.forEach((key, val) -> {
                if (!mgr.field_186527_c.containsKey(key)) {
                    mgr.field_186527_c.put(key, val);
                }
            });
            Placebo.LOGGER.info("Registered {} additional loot tables.", (Object)tables.keySet().size());
        }
    }
}

