/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.gen.WorldFeature;
import shadows.apotheosis.deadly.gen.WorldGenerator;
import shadows.apotheosis.ench.asm.EnchHooks;
import shadows.apotheosis.util.ArmorSet;
import shadows.apotheosis.util.NameHelper;
import shadows.placebo.util.AttributeHelper;

public class BossItem
extends WorldFeature.WorldFeatureItem {
    public static final List<Effect> POTIONS = new ArrayList<Effect>();
    public static final Map<IAttribute, RandomValueRange> SWORD_ATTR = ImmutableMap.of((Object)SharedMonsterAttributes.field_111264_e, (Object)new RandomValueRange(0.5f, 5.0f), (Object)SharedMonsterAttributes.field_221120_g, (Object)new RandomValueRange(0.5f, 2.0f), (Object)SharedMonsterAttributes.field_188790_f, (Object)new RandomValueRange(0.25f, 1.0f), (Object)SharedMonsterAttributes.field_111263_d, (Object)new RandomValueRange(0.05f, 0.25f));
    public static final Map<IAttribute, RandomValueRange> BOW_ATTR = ImmutableMap.of((Object)SharedMonsterAttributes.field_111266_c, (Object)new RandomValueRange(0.25f, 2.0f), (Object)SharedMonsterAttributes.field_188792_h, (Object)new RandomValueRange(0.1f, 1.0f), (Object)SharedMonsterAttributes.field_111263_d, (Object)new RandomValueRange(0.05f, 0.4f));
    public static final Map<IAttribute, RandomValueRange> TOOL_ATTR = ImmutableMap.of((Object)PlayerEntity.REACH_DISTANCE, (Object)new RandomValueRange(0.5f, 3.0f), (Object)SharedMonsterAttributes.field_188792_h, (Object)new RandomValueRange(0.5f, 2.0f));
    public static final Map<IAttribute, RandomValueRange> ARMOR_ATTR = ImmutableMap.builder().put((Object)SharedMonsterAttributes.field_188791_g, (Object)new RandomValueRange(0.2f, 2.0f)).put((Object)SharedMonsterAttributes.field_189429_h, (Object)new RandomValueRange(0.1f, 0.5f)).put((Object)SharedMonsterAttributes.field_111266_c, (Object)new RandomValueRange(0.2f, 0.8f)).put((Object)SharedMonsterAttributes.field_111267_a, (Object)new RandomValueRange(3.0f, 15.0f)).put((Object)LivingEntity.SWIM_SPEED, (Object)new RandomValueRange(0.2f, 0.8f)).put((Object)LivingEntity.ENTITY_GRAVITY, (Object)new RandomValueRange(-0.08f, 0.08f)).build();
    public static final Map<IAttribute, RandomValueRange> SHIELD_ATTR = ImmutableMap.of((Object)SharedMonsterAttributes.field_188791_g, (Object)new RandomValueRange(5.0f, 10.0f), (Object)SharedMonsterAttributes.field_189429_h, (Object)new RandomValueRange(1.0f, 4.0f), (Object)SharedMonsterAttributes.field_111266_c, (Object)new RandomValueRange(0.3f, 1.0f), (Object)SharedMonsterAttributes.field_111267_a, (Object)new RandomValueRange(5.0f, 25.0f));
    public static final ArmorSet GOLD_GEAR = new ArmorSet(0, Items.field_151010_B, Items.field_185159_cQ, Items.field_151151_aj, Items.field_151149_ai, Items.field_151171_ah, Items.field_151169_ag).addExtraMains(Items.field_151006_E, Items.field_151011_C, Items.field_151005_D);
    public static final ArmorSet IRON_GEAR = new ArmorSet(1, Items.field_151040_l, Items.field_185159_cQ, Items.field_151167_ab, Items.field_151165_aa, Items.field_151030_Z, Items.field_151028_Y).addExtraMains(Items.field_151036_c, Items.field_151037_a, Items.field_151035_b);
    public static final ArmorSet DIAMOND_GEAR = new ArmorSet(2, Items.field_151048_u, Items.field_185159_cQ, Items.field_151175_af, Items.field_151173_ae, Items.field_151163_ad, Items.field_151161_ac).addExtraMains(Items.field_151056_x, Items.field_151047_v, Items.field_151046_w);
    public static final Predicate<Goal> IS_VILLAGER_ATTACK;
    protected final EntityType<?> entityEntry;
    protected AxisAlignedBB entityAABB;

    public BossItem(int weight, ResourceLocation entity) {
        super(weight);
        this.entityEntry = (EntityType)ForgeRegistries.ENTITIES.getValue(entity);
        Preconditions.checkNotNull(this.entityEntry, (Object)("Invalid BossItem (not an entity) created with reloc: " + entity));
    }

    public AxisAlignedBB getAABB(IWorld world) {
        if (this.entityAABB == null) {
            this.entityAABB = this.entityEntry.func_200721_a(world.func_201672_e()).func_70046_E();
        }
        if (this.entityAABB == null) {
            this.entityAABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        return this.entityAABB;
    }

    @Override
    public void place(IWorld world, BlockPos pos) {
        this.place(world, pos, world.func_201674_k());
    }

    public void place(IWorld world, BlockPos pos, Random rand) {
        MobEntity entity = (MobEntity)this.entityEntry.func_200721_a(world.func_201672_e());
        BossItem.initBoss(rand, entity);
        entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        world.func_217376_c((Entity)entity);
        entity.field_70714_bg.field_220892_d.removeIf(IS_VILLAGER_ATTACK);
        entity.func_110163_bv();
        for (BlockPos p : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, -1, -2), (BlockPos)pos.func_177982_a(2, 1, 2))) {
            world.func_180501_a(p, Blocks.field_150350_a.func_176223_P(), 2);
        }
        for (BlockPos p : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, -2, -2), (BlockPos)pos.func_177982_a(2, -2, 2))) {
            world.func_180501_a(p, Blocks.field_180395_cM.func_176223_P(), 2);
        }
        entity.getPersistentData().func_74757_a("apoth_boss", true);
        WorldGenerator.debugLog(pos, "Boss " + entity.func_200200_C_().func_150261_e());
    }

    public static void initBoss(Random random, MobEntity entity) {
        int res;
        int duration = entity instanceof CreeperEntity ? 6000 : Integer.MAX_VALUE;
        int regen = DeadlyConfig.bossRegenLevel.func_186511_a(random) - 1;
        if (regen >= 0) {
            entity.func_195064_c(new EffectInstance(Effects.field_76428_l, duration, regen));
        }
        if ((res = DeadlyConfig.bossResistLevel.func_186511_a(random) - 1) >= 0) {
            entity.func_195064_c(new EffectInstance(Effects.field_76429_m, duration, res));
        }
        if (random.nextFloat() < DeadlyConfig.bossFireRes) {
            entity.func_195064_c(new EffectInstance(Effects.field_76426_n, duration));
        }
        if (random.nextFloat() < DeadlyConfig.bossWaterBreathing) {
            entity.func_195064_c(new EffectInstance(Effects.field_76427_o, duration));
        }
        AttributeHelper.multiplyFinal((LivingEntity)entity, (IAttribute)SharedMonsterAttributes.field_111264_e, (String)"boss_damage_bonus", (double)(DeadlyConfig.bossHealthMultiplier.func_186507_b(random) - 1.0f));
        AttributeHelper.multiplyFinal((LivingEntity)entity, (IAttribute)SharedMonsterAttributes.field_111267_a, (String)"boss_health_mult", (double)(DeadlyConfig.bossHealthMultiplier.func_186507_b(random) - 1.0f));
        AttributeHelper.addToBase((LivingEntity)entity, (IAttribute)SharedMonsterAttributes.field_111266_c, (String)"boss_knockback_resist", (double)DeadlyConfig.bossKnockbackResist.func_186507_b(random));
        AttributeHelper.multiplyFinal((LivingEntity)entity, (IAttribute)SharedMonsterAttributes.field_111263_d, (String)"boss_speed_mult", (double)(DeadlyConfig.bossSpeedMultiplier.func_186507_b(random) - 1.0f));
        entity.func_70606_j(entity.func_110138_aP());
        String name = NameHelper.setEntityName(random, (LivingEntity)entity);
        entity.func_110163_bv();
        int level = 0;
        for (int i = 0; i < ArmorSet.SORTED_SETS.size() - 1; ++i) {
            if (!(random.nextDouble() < (double)DeadlyConfig.bossLevelUpChance)) continue;
            ++level;
        }
        ArmorSet.SORTED_SETS.get(level).apply((LivingEntity)entity);
        if (entity instanceof SkeletonEntity) {
            entity.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151031_f));
        }
        int guaranteed = random.nextInt(6);
        ItemStack stack = entity.func_184582_a(EquipmentSlotType.values()[guaranteed]);
        while (guaranteed == 1 || stack.func_190926_b()) {
            guaranteed = random.nextInt(6);
            stack = entity.func_184582_a(EquipmentSlotType.values()[guaranteed]);
        }
        for (EquipmentSlotType s : EquipmentSlotType.values()) {
            if (s.ordinal() == guaranteed) {
                entity.func_184642_a(s, 2.0f);
            } else {
                entity.func_184642_a(s, ThreadLocalRandom.current().nextFloat());
            }
            if (s.ordinal() == guaranteed) {
                BossItem.modifyBossItem(stack, random, name);
                continue;
            }
            if (!(random.nextDouble() < (double)DeadlyConfig.bossEnchantChance)) continue;
            List ench = EnchantmentHelper.func_77513_b((Random)random, (ItemStack)stack, (int)(30 + random.nextInt(Apotheosis.enableEnch ? 20 : 10)), (boolean)true);
            EnchantmentHelper.func_82782_a((Map)ench.stream().collect(Collectors.toMap(d -> d.field_76302_b, d -> d.field_76303_c, (v1, v2) -> v1 > v2 ? v1 : v2, HashMap::new)), (ItemStack)stack);
        }
        if (POTIONS.isEmpty()) {
            BossItem.initPotions();
        }
        if (random.nextDouble() < (double)DeadlyConfig.bossPotionChance) {
            entity.func_195064_c(new EffectInstance(POTIONS.get(random.nextInt(POTIONS.size())), duration, random.nextInt(3) + 1));
        }
    }

    public static void initPotions() {
        for (Effect p2 : ForgeRegistries.POTIONS) {
            if (!p2.func_188408_i() || p2.func_76403_b()) continue;
            POTIONS.add(p2);
        }
        POTIONS.removeIf(p -> DeadlyConfig.BLACKLISTED_POTIONS.contains(p.getRegistryName()));
    }

    public static void modifyBossItem(ItemStack stack, Random random, String bossName) {
        List ench = EnchantmentHelper.func_77513_b((Random)random, (ItemStack)stack, (int)(Apotheosis.enableEnch ? 60 : 30), (boolean)true);
        EnchantmentHelper.func_82782_a(ench.stream().collect(Collectors.toMap(d -> d.field_76302_b, d -> d.field_76303_c)), (ItemStack)stack);
        NameHelper.setItemName(random, stack, bossName, ((EnchantmentData)ench.get((int)random.nextInt((int)ench.size()))).field_76302_b);
        EquipmentType.getTypeForStack(stack).apply(stack, random);
        HashMap enchMap = new HashMap();
        for (Map.Entry e : EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet()) {
            enchMap.put(e.getKey(), Math.min(EnchHooks.getMaxLevel((Enchantment)e.getKey()), (Integer)e.getValue() + random.nextInt(2)));
        }
        EnchantmentHelper.func_82782_a(enchMap, (ItemStack)stack);
        stack.func_77978_p().func_74757_a("apoth:boss", true);
    }

    static {
        ArmorSet.LEVEL_TO_SETS.put(0, GOLD_GEAR);
        ArmorSet.LEVEL_TO_SETS.put(1, IRON_GEAR);
        ArmorSet.LEVEL_TO_SETS.put(2, DIAMOND_GEAR);
        IS_VILLAGER_ATTACK = a -> a instanceof NearestAttackableTargetGoal && ((NearestAttackableTargetGoal)a).field_75307_b == VillagerEntity.class;
    }

    static enum EquipmentType {
        SWORD(SWORD_ATTR, s -> EquipmentSlotType.MAINHAND),
        BOW(BOW_ATTR, s -> EquipmentSlotType.MAINHAND),
        TOOL(TOOL_ATTR, s -> EquipmentSlotType.MAINHAND),
        ARMOR(ARMOR_ATTR, s -> ((ArmorItem)s.func_77973_b()).func_185083_B_()),
        SHIELD(SHIELD_ATTR, s -> EquipmentSlotType.OFFHAND);

        final Map<IAttribute, RandomValueRange> attributes;
        final Function<ItemStack, EquipmentSlotType> type;

        private EquipmentType(Map<IAttribute, RandomValueRange> attributes, Function<ItemStack, EquipmentSlotType> type) {
            this.attributes = attributes;
            this.type = type;
        }

        public void apply(ItemStack stack, Random rand) {
            int numAttributes = Math.min(this.attributes.size(), 1 + rand.nextInt(3));
            ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
            ArrayList<IAttribute> attr = new ArrayList<IAttribute>(this.attributes.keySet());
            Collections.shuffle(attr, rand);
            for (int i = 0; i < numAttributes; ++i) {
                modifiers.add(new AttributeModifier(((IAttribute)attr.get(i)).func_111108_a(), (double)this.attributes.get(attr.get(i)).func_186507_b(rand), AttributeModifier.Operation.ADDITION));
            }
            modifiers.forEach(m -> stack.func_185129_a(m.func_111166_b(), m, this.type.apply(stack)));
        }

        public static EquipmentType getTypeForStack(ItemStack stack) {
            Item i = stack.func_77973_b();
            if (i instanceof SwordItem) {
                return SWORD;
            }
            if (i instanceof BowItem) {
                return BOW;
            }
            if (i instanceof ArmorItem) {
                return ARMOR;
            }
            if (i instanceof ShieldItem) {
                return SHIELD;
            }
            return TOOL;
        }
    }
}

