/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.EnchantmentContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.Stats;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import shadows.apotheosis.advancements.AdvancementTriggers;
import shadows.apotheosis.ench.EnchModule;
import shadows.apotheosis.ench.objects.BlockHellBookshelf;

public class ContainerEnchantmentExt
extends EnchantmentContainer {
    protected World world;
    protected BlockPos position;

    public ContainerEnchantmentExt(int id, PlayerInventory inv, IWorldPosCallable wPos) {
        super(id, inv, wPos);
        this.world = (World)wPos.func_221484_a((w, p) -> w).get();
        this.position = (BlockPos)wPos.func_221484_a((w, p) -> p).get();
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        int level = this.field_75167_g[id];
        boolean ret = super.func_75140_a(playerIn, id);
        if (ret) {
            playerIn.func_195066_a(Stats.field_188091_Y);
            if (playerIn instanceof ServerPlayerEntity) {
                AdvancementTriggers.ENCHANTED_ITEM.func_192190_a((ServerPlayerEntity)playerIn, this.field_75168_e.func_70301_a(0), level);
            }
        }
        return ret;
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (inventoryIn == this.field_75168_e) {
            ItemStack itemstack = inventoryIn.func_70301_a(0);
            if (!itemstack.func_190926_b() && itemstack.func_77956_u()) {
                if (!this.world.field_72995_K) {
                    float power = this.getEnchPower();
                    this.field_75169_l.setSeed(this.field_178149_f.func_221495_b());
                    for (int i1 = 0; i1 < 3; ++i1) {
                        this.field_75167_g[i1] = EnchantmentHelper.func_77514_a((Random)this.field_75169_l, (int)i1, (int)((int)power), (ItemStack)itemstack);
                        this.field_185001_h[i1] = -1;
                        this.field_185002_i[i1] = -1;
                        if (this.field_75167_g[i1] < i1 + 1) {
                            this.field_75167_g[i1] = 0;
                        }
                        this.field_75167_g[i1] = ForgeEventFactory.onEnchantmentLevelSet((World)this.world, (BlockPos)this.position, (int)i1, (int)((int)power), (ItemStack)itemstack, (int)this.field_75167_g[i1]);
                    }
                    for (int j1 = 0; j1 < 3; ++j1) {
                        List<EnchantmentData> list;
                        if (this.field_75167_g[j1] <= 0 || (list = this.getEnchantmentList(itemstack, j1, this.field_75167_g[j1])) == null || list.isEmpty()) continue;
                        EnchantmentData enchantmentdata = list.get(this.field_75169_l.nextInt(list.size()));
                        this.field_185001_h[j1] = Registry.field_212628_q.func_148757_b((Object)enchantmentdata.field_76302_b);
                        this.field_185002_i[j1] = enchantmentdata.field_76303_c;
                    }
                    this.func_75142_b();
                }
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.field_75167_g[i] = 0;
                    this.field_185001_h[i] = -1;
                    this.field_185002_i[i] = -1;
                }
            }
        }
    }

    private List<EnchantmentData> getEnchantmentList(ItemStack stack, int enchantSlot, int level) {
        this.field_75169_l.setSeed(this.field_178149_f.func_221495_b() + enchantSlot);
        List list = EnchantmentHelper.func_77513_b((Random)this.field_75169_l, (ItemStack)stack, (int)level, (boolean)false);
        if (stack.func_77973_b() == Items.field_151122_aG && list.size() > 1) {
            list.remove(this.field_75169_l.nextInt(list.size()));
        }
        return list;
    }

    public float getEnchPower() {
        float[] powers = new float[]{0.0f, 0.0f};
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (j == 0 && k == 0 || !this.world.func_175623_d(this.position.func_177982_a(k, 0, j)) || !this.world.func_175623_d(this.position.func_177982_a(k, 1, j))) continue;
                this.getSinglePower(powers, this.position.func_177982_a(k * 2, 0, j * 2));
                this.getSinglePower(powers, this.position.func_177982_a(k * 2, 1, j * 2));
                if (k == 0 || j == 0) continue;
                this.getSinglePower(powers, this.position.func_177982_a(k * 2, 0, j));
                this.getSinglePower(powers, this.position.func_177982_a(k * 2, 1, j));
                this.getSinglePower(powers, this.position.func_177982_a(k, 0, j * 2));
                this.getSinglePower(powers, this.position.func_177982_a(k, 1, j * 2));
            }
        }
        return Math.min(EnchModule.maxPower, Math.min(powers[0], EnchModule.maxNormalPower) + powers[1]);
    }

    public void getSinglePower(float[] powers, BlockPos pos) {
        BlockState state = this.world.func_180495_p(pos);
        boolean hell = state.func_177230_c() instanceof BlockHellBookshelf;
        float power = state.getEnchantPowerBonus((IWorldReader)this.world, pos);
        int n = hell ? 1 : 0;
        powers[n] = powers[n] + power;
    }
}

