/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench;

import com.udojava.evalex.Expression;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;

public class EnchantmentInfo {
    static Map<Enchantment, PowerFunc> overrides = new HashMap<Enchantment, PowerFunc>();
    final Enchantment ench;
    final int maxLevel;
    final int minLevel;
    PowerFunc maxPower;
    PowerFunc minPower;

    public EnchantmentInfo(Enchantment ench, int maxLevel, int minLevel) {
        this.ench = ench;
        this.maxLevel = maxLevel;
        this.minLevel = minLevel;
        this.maxPower = level -> ench.func_223551_b(level);
        if (overrides.containsKey(ench)) {
            this.maxPower = overrides.get(ench);
        }
        this.minPower = level -> ench.func_77321_a(level);
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getMinPower(int level) {
        return this.minPower.getPower(level);
    }

    public int getMaxPower(int level) {
        return this.maxPower.getPower(level);
    }

    public void setMaxPower(PowerFunc maxPower) {
        this.maxPower = maxPower;
    }

    public void setMinPower(PowerFunc minPower) {
        this.minPower = minPower;
    }

    static {
        overrides.put(Enchantments.field_92091_k, l -> Enchantments.field_92091_k.func_77321_a(l) + 20);
        overrides.put(Enchantments.field_180313_o, l -> Enchantments.field_180313_o.func_77321_a(l) + 20);
        overrides.put(Enchantments.field_77334_n, l -> Enchantments.field_77334_n.func_77321_a(l) + 20);
        overrides.put(Enchantments.field_222193_H, l -> Enchantments.field_222193_H.func_77321_a(l) + 20);
    }

    public static class ExpressionPowerFunc
    implements PowerFunc {
        Expression ex;

        public ExpressionPowerFunc(String func) {
            this.ex = new Expression(func);
        }

        @Override
        public int getPower(int level) {
            return this.ex.setVariable("x", new BigDecimal(level)).eval().intValue();
        }
    }

    public static interface PowerFunc {
        public int getPower(int var1);
    }
}

