/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.WeightedRandom;
import shadows.apotheosis.util.TagBuilder;
import shadows.placebo.util.PlaceboUtil;

public class ArmorSet {
    public static final Map<Integer, ArmorSet> LEVEL_TO_SETS = new HashMap<Integer, ArmorSet>();
    public static final List<ArmorSet> SORTED_SETS = new ArrayList<ArmorSet>();
    final int level;
    ItemStack mainhand;
    ItemStack offhand;
    ItemStack feet;
    ItemStack legs;
    ItemStack chest;
    ItemStack head;
    EnumMap<EquipmentSlotType, ItemStack> slotMap = new EnumMap(EquipmentSlotType.class);
    List<WeightedRandomStack> possibleMainhands = new ArrayList<WeightedRandomStack>();

    public ArmorSet(int level, ItemStack ... set) {
        this.level = level;
        this.mainhand = set[0];
        this.offhand = set[1];
        this.feet = set[2];
        this.legs = set[3];
        this.chest = set[4];
        this.head = set[5];
        for (int i = 0; i < 6; ++i) {
            this.slotMap.put(EquipmentSlotType.values()[i], set[i]);
        }
    }

    public ArmorSet(int level, Object ... set) {
        this(level, PlaceboUtil.toStackArray((Object[])set));
    }

    public LivingEntity apply(LivingEntity entity) {
        for (EquipmentSlotType e : EquipmentSlotType.values()) {
            entity.func_184201_a(e, this.slotMap.get(e).func_77946_l());
        }
        if (!this.possibleMainhands.isEmpty()) {
            entity.func_184611_a(Hand.MAIN_HAND, ((WeightedRandomStack)WeightedRandom.func_76271_a((Random)ThreadLocalRandom.current(), this.possibleMainhands)).getStack().func_77946_l());
        }
        return entity;
    }

    public CompoundNBT apply(CompoundNBT entity) {
        ItemStack main = this.mainhand;
        if (!this.possibleMainhands.isEmpty()) {
            main = ((WeightedRandomStack)WeightedRandom.func_76271_a((Random)ThreadLocalRandom.current(), this.possibleMainhands)).getStack();
        }
        return TagBuilder.setEquipment(entity, main, this.offhand, this.feet, this.legs, this.chest, this.head);
    }

    public ArmorSet addExtraMains(ItemStack ... tools) {
        this.setupList();
        for (ItemStack s : tools) {
            this.possibleMainhands.add(new WeightedRandomStack(s, 1));
        }
        return this;
    }

    public ArmorSet addExtraMains(Object ... tools) {
        return this.addExtraMains(PlaceboUtil.toStackArray((Object[])tools));
    }

    public List<WeightedRandomStack> getPossibleMainhands() {
        return this.possibleMainhands;
    }

    public void setupList() {
        if (this.possibleMainhands.isEmpty()) {
            this.possibleMainhands.add(new WeightedRandomStack(this.mainhand, 3));
        }
    }

    public static void sortSets() {
        List sorted = LEVEL_TO_SETS.entrySet().stream().sorted((e1, e2) -> ((Integer)e1.getKey()).compareTo((Integer)e2.getKey())).map(a -> (ArmorSet)a.getValue()).collect(Collectors.toList());
        SORTED_SETS.clear();
        SORTED_SETS.addAll(sorted);
    }

    public static class WeightedRandomStack
    extends WeightedRandom.Item {
        final ItemStack stack;

        public WeightedRandomStack(ItemStack stack, int weight) {
            super(weight);
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }
}

