/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.items.meta;

import com.teammetallurgy.aquaculture.items.meta.MetaItemFood;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class SubItemFood {
    public int damage;
    public MetaItemFood item;
    public String unlocalizedName;
    public final int itemUseDuration;
    private final int healAmount;
    private final float saturationModifier;
    private final boolean isWolfsFavoriteMeat;
    private boolean alwaysEdible;
    private Potion potion;
    private int potionDuration;
    private int potionAmplifier;
    private float potionEffectProbability;
    private int eatTime;

    public SubItemFood(MetaItemFood metaItem, int heal, float saturation, boolean isWolfFood) {
        this.item = metaItem;
        this.damage = this.item.addSubItem(this);
        this.itemUseDuration = 32;
        this.healAmount = heal;
        this.isWolfsFavoriteMeat = isWolfFood;
        this.saturationModifier = saturation;
        this.eatTime = 32;
    }

    public SubItemFood(MetaItemFood metaItem, int heal, boolean isWolfFood) {
        this(metaItem, heal, 0.6f, isWolfFood);
    }

    public SubItemFood setCreativeTab(CreativeTabs tab) {
        this.item.func_77637_a(tab);
        return this;
    }

    public SubItemFood setUnlocalizedName(String name) {
        this.unlocalizedName = name;
        return this;
    }

    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    public ItemStack getItemStack(int amount) {
        return new ItemStack((Item)this.item, amount, this.damage);
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        return this.unlocalizedName;
    }

    public SubItemFood setEatTime(int eatTime) {
        this.eatTime = eatTime;
        return this;
    }

    public ItemStack onEaten(ItemStack par1ItemStack, World par2World, EntityLivingBase entity) {
        par1ItemStack.func_190918_g(1);
        if (!(entity instanceof EntityPlayer)) {
            return par1ItemStack;
        }
        EntityPlayer player = (EntityPlayer)entity;
        player.func_71024_bL().func_75122_a(this.getHealAmount(), this.getSaturationModifier());
        par2World.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, par2World.field_73012_v.nextFloat() * 0.1f + 0.9f);
        this.onFoodEaten(par1ItemStack, par2World, player);
        return par1ItemStack;
    }

    protected void onFoodEaten(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!par2World.field_72995_K && this.potion != null && par2World.field_73012_v.nextFloat() < this.potionEffectProbability) {
            par3EntityPlayer.func_70690_d(new PotionEffect(this.potion, this.potionDuration * 20, this.potionAmplifier));
        }
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return this.eatTime;
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.EAT;
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, EnumHand hand) {
        if (par3EntityPlayer.func_71043_e(this.alwaysEdible)) {
            par3EntityPlayer.func_184598_c(hand);
        }
        return par1ItemStack;
    }

    public int getHealAmount() {
        return this.healAmount;
    }

    public float getSaturationModifier() {
        return this.saturationModifier;
    }

    public boolean isWolfsFavoriteMeat() {
        return this.isWolfsFavoriteMeat;
    }

    public SubItemFood setPotionEffect(Potion potion, int duration, int amplifier, float effectPribability) {
        this.potion = potion;
        this.potionDuration = duration;
        this.potionAmplifier = amplifier;
        this.potionEffectProbability = effectPribability;
        return this;
    }

    public SubItemFood setAlwaysEdible() {
        this.alwaysEdible = true;
        return this;
    }
}

