/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.loot;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class WeightedLootSet {
    public Map<Integer, ItemStack> loot = new HashMap<Integer, ItemStack>();
    public Map<Integer, Integer> lootMin = new HashMap<Integer, Integer>();
    public Map<Integer, Integer> lootMax = new HashMap<Integer, Integer>();
    public int totalWeight = 0;

    public void addLoot(Object item, int weight) {
        this.addLoot(item, weight, 1, 1);
    }

    public void addLoot(Object item, int weight, int min, int max) {
        if (item instanceof Item) {
            this.addLoot(new ItemStack((Item)item), weight, min, max);
        } else if (item instanceof Block) {
            this.addLoot(new ItemStack((Block)item), weight, min, max);
        } else if (item instanceof ItemStack) {
            this.addLoot((ItemStack)item, weight, min, max);
        }
    }

    public void addLoot(ItemStack stack, int weight, int min, int max) {
        if (weight <= 0 || stack == null) {
            return;
        }
        this.loot.put(this.totalWeight + weight, stack);
        this.lootMin.put(this.totalWeight + weight, min);
        this.lootMax.put(this.totalWeight + weight, max);
        this.totalWeight += weight;
    }

    public ItemStack getRandomLoot() {
        Random rand = new Random();
        int weight = rand.nextInt(this.totalWeight + 1);
        ItemStack stack = null;
        Set<Integer> keySet = this.loot.keySet();
        Object[] keys = keySet.toArray(new Integer[keySet.size()]);
        Arrays.sort(keys);
        for (Object key : keys) {
            if ((Integer)key < weight) continue;
            stack = this.loot.get(key).func_77946_l();
            int min = this.lootMin.get(key);
            int max = this.lootMax.get(key);
            int amount = rand.nextInt(max - min + 1) + min;
            stack.func_190920_e(amount);
            if (stack.func_77973_b() != Items.field_151134_bR) break;
            break;
        }
        return stack;
    }
}

