/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.block;

import com.teammetallurgy.aquaculture.block.tileentity.TackleBoxTileEntity;
import com.teammetallurgy.aquaculture.misc.StackHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TackleBoxBlock
extends ContainerBlock
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape NORTH_SOUTH = Block.func_208617_a((double)0.8, (double)0.0, (double)3.9, (double)15.2, (double)9.0, (double)12.2);
    private static final VoxelShape EAST_WEST = Block.func_208617_a((double)3.9, (double)0.0, (double)0.8, (double)12.2, (double)9.0, (double)15.2);

    public TackleBoxBlock() {
        super(Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151668_h).func_200948_a(4.0f, 5.0f).func_200947_a(SoundType.field_185852_e));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public TileEntity func_196283_a_(@Nonnull IBlockReader blockReader) {
        return new TackleBoxTileEntity();
    }

    public boolean func_190946_v(BlockState state) {
        return true;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case NORTH: 
            case SOUTH: {
                return NORTH_SOUTH;
            }
            case EAST: 
            case WEST: {
                return EAST_WEST;
            }
        }
        return super.func_220053_a(state, blockReader, pos, context);
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return true;
        }
        INamedContainerProvider container = this.func_220052_b(state, world, pos);
        if (container != null && player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            if (player.func_70093_af()) {
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity != null) {
                    StackHelper.giveItem((PlayerEntity)serverPlayer, StackHelper.storeTEInStack(new ItemStack((IItemProvider)this), tileEntity));
                    world.func_217377_a(pos, false);
                    world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.6f, 0.8f);
                }
            } else {
                NetworkHooks.openGui((ServerPlayerEntity)serverPlayer, (INamedContainerProvider)container, (BlockPos)pos);
            }
        }
        return true;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction placerFacing = context.func_195992_f().func_176734_d();
        IFluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)placerFacing)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof TackleBoxTileEntity) {
            ((TackleBoxTileEntity)tileentity).setCustomName(stack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            world.func_175666_e(pos, (Block)this);
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @Nonnull
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    @Nonnull
    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TackleBoxTileEntity) {
            LazyOptional redstone = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(ItemHandlerHelper::calcRedstoneFromInventory);
            return (Integer)redstone.orElse((Object)0);
        }
        return 0;
    }

    @Nonnull
    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, WATERLOGGED});
    }

    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader blockReader, @Nonnull BlockPos pos, PathType type) {
        return false;
    }

    public void func_180657_a(@Nonnull World world, PlayerEntity player, @Nonnull BlockPos pos, BlockState state, @Nullable TileEntity tileEntity, @Nonnull ItemStack stack) {
        player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
        player.func_71020_j(0.005f);
        if (tileEntity != null) {
            TackleBoxBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)StackHelper.storeTEInStack(new ItemStack((IItemProvider)this), tileEntity));
        }
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            this.dropInventory(world, pos);
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    private void dropInventory(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handler -> StackHelper.dropInventory(world, pos, handler));
        }
    }
}

