/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.FishMountEntity;
import com.teammetallurgy.aquaculture.entity.FishType;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class FishMountRenderer
extends EntityRenderer<FishMountEntity> {
    public static final ModelResourceLocation OAK = new ModelResourceLocation(new ResourceLocation("aquaculture", "oak_fish_mount"), "");
    public static final ModelResourceLocation SPRUCE = new ModelResourceLocation(new ResourceLocation("aquaculture", "spruce_fish_mount"), "");
    public static final ModelResourceLocation BIRCH = new ModelResourceLocation(new ResourceLocation("aquaculture", "birch_fish_mount"), "");
    public static final ModelResourceLocation JUNGLE = new ModelResourceLocation(new ResourceLocation("aquaculture", "jungle_fish_mount"), "");
    public static final ModelResourceLocation ACACIA = new ModelResourceLocation(new ResourceLocation("aquaculture", "acacia_fish_mount"), "");
    public static final ModelResourceLocation DARK_OAK = new ModelResourceLocation(new ResourceLocation("aquaculture", "dark_oak_fish_mount"), "");
    private final Minecraft mc = Minecraft.func_71410_x();

    public FishMountRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void doRender(FishMountEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        BlockPos pos = entity.func_174857_n();
        double translateX = (double)pos.func_177958_n() - entity.field_70165_t + x;
        double translateY = (double)pos.func_177956_o() - entity.field_70163_u + y;
        double translateZ = (double)pos.func_177952_p() - entity.field_70161_v + z;
        GlStateManager.translated((double)(translateX + 0.5), (double)(translateY + 0.5), (double)(translateZ + 0.5));
        GlStateManager.rotatef((float)entity.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)(180.0f - entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        this.field_76990_c.field_78724_e.func_110577_a(AtlasTexture.field_110575_b);
        BlockRendererDispatcher rendererDispatcher = this.mc.func_175602_ab();
        ModelManager modelmanager = rendererDispatcher.func_175023_a().func_178126_b();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (this.field_188301_f) {
            GlStateManager.enableColorMaterial();
            GlStateManager.setupSolidRenderingTextureCombine((int)this.func_188298_c((Entity)entity));
        }
        if (entity.func_200600_R().getRegistryName() != null) {
            ModelResourceLocation location = new ModelResourceLocation(entity.func_200600_R().getRegistryName(), "");
            rendererDispatcher.func_175019_b().func_178262_a(modelmanager.func_174953_a(location), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.field_188301_f) {
            GlStateManager.tearDownSolidRenderingTextureCombine();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.popMatrix();
        GlStateManager.enableLighting();
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.4375f);
        this.renderFish(entity, x, y, z);
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
        if (!this.mc.field_71474_y.field_74319_N && entity.func_195048_a(this.mc.field_71476_x.func_216347_e()) < 0.24) {
            this.renderName(entity, x + (double)((float)entity.func_174811_aO().func_82601_c() * 0.3f), y - 0.25, z + (double)((float)entity.func_174811_aO().func_82599_e() * 0.3f));
        }
    }

    @Nullable
    protected ResourceLocation getEntityTexture(@Nonnull FishMountEntity entity) {
        return null;
    }

    private void renderFish(FishMountEntity fishMount, double x, double y, double z) {
        Entity entityFish = fishMount.entity;
        if (entityFish != null) {
            GlStateManager.pushMatrix();
            float depth = entityFish.func_70111_Y();
            if (entityFish instanceof PufferfishEntity) {
                depth += 0.09f;
            } else if (entityFish instanceof AquaFishEntity && AquaFishEntity.TYPES.get(entityFish.func_200600_R()).equals((Object)FishType.LONGNOSE)) {
                GlStateManager.translatef((float)-0.1f, (float)-0.18f, (float)0.0f);
            }
            GlStateManager.translatef((float)0.0f, (float)0.0f, (float)depth);
            GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            entityFish.func_70012_b(x, y, z, 0.0f, 0.0f);
            this.mc.func_175598_ae().func_188391_a(entityFish, 0.0, 0.0, 0.0, 0.0f, 0.0f, false);
            GlStateManager.popMatrix();
        }
    }

    protected void renderName(FishMountEntity entity, double x, double y, double z) {
        ItemStack stack = entity.getDisplayedItem();
        if (!stack.func_190926_b() && entity.entity != null) {
            float sneaking;
            double distanceSq = entity.func_195048_a(this.field_76990_c.field_217783_c.func_216785_c());
            float f = sneaking = entity.func_213287_bg() ? 32.0f : 64.0f;
            if (!(distanceSq >= (double)(sneaking * sneaking))) {
                String name = entity.entity.func_145748_c_().func_150254_d();
                this.func_147906_a((Entity)entity, name, x, y, z, 64);
                if (stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("fishWeight")) {
                    double weight = stack.func_77978_p().func_74769_h("fishWeight");
                    String lb = weight == 1.0 ? " lb" : " lbs";
                    DecimalFormat df = new DecimalFormat("#,###.##");
                    BigDecimal bd = new BigDecimal(weight);
                    if ((bd = bd.round(new MathContext(3))).doubleValue() > 999.0) {
                        this.func_147906_a((Entity)entity, I18n.func_135052_a((String)"aquaculture.fishWeight.weight", (Object[])new Object[]{df.format((int)bd.doubleValue()) + lb}), x, y - 0.25, z, 64);
                    } else {
                        this.func_147906_a((Entity)entity, I18n.func_135052_a((String)"aquaculture.fishWeight.weight", (Object[])new Object[]{bd + lb}), x, y - 0.25, z, 64);
                    }
                }
            }
        }
    }
}

