/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.inventory.container;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.block.tileentity.TackleBoxTileEntity;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import com.teammetallurgy.aquaculture.init.AquaGuis;
import com.teammetallurgy.aquaculture.inventory.container.slot.SlotFishingRod;
import com.teammetallurgy.aquaculture.inventory.container.slot.SlotHidable;
import com.teammetallurgy.aquaculture.item.BaitItem;
import com.teammetallurgy.aquaculture.item.HookItem;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class TackleBoxContainer
extends Container {
    public TackleBoxTileEntity tackleBox;
    private int rows = 4;
    private int collumns = 4;
    public Slot slotHook;
    public Slot slotBait;
    public Slot slotLine;
    public Slot slotBobber;

    public TackleBoxContainer(int windowID, BlockPos pos, PlayerInventory playerInventory) {
        super(AquaGuis.TACKLE_BOX, windowID);
        this.tackleBox = (TackleBoxTileEntity)playerInventory.field_70458_d.field_70170_p.func_175625_s(pos);
        if (this.tackleBox != null) {
            this.tackleBox.openInventory(playerInventory.field_70458_d);
            this.tackleBox.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                SlotFishingRod fishingRod = (SlotFishingRod)this.func_75146_a((Slot)new SlotFishingRod((IItemHandler)handler, 0, 117, 21));
                this.slotHook = this.func_75146_a((Slot)new SlotHidable(fishingRod, 0, 106, 44));
                this.slotBait = this.func_75146_a((Slot)new SlotHidable(fishingRod, 1, 129, 44){

                    @Override
                    public boolean func_82869_a(PlayerEntity player) {
                        return false;
                    }
                });
                this.slotLine = this.func_75146_a((Slot)new SlotHidable(fishingRod, 2, 106, 67));
                this.slotBobber = this.func_75146_a((Slot)new SlotHidable(fishingRod, 3, 129, 67));
                for (int column = 0; column < this.collumns; ++column) {
                    for (int row = 0; row < this.rows; ++row) {
                        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)handler, 1 + row + column * this.collumns, 8 + row * 18, 8 + column * 18){

                            public boolean func_75214_a(@Nonnull ItemStack stack) {
                                Item item = stack.func_77973_b();
                                boolean isDyeable = stack.func_77973_b() instanceof IDyeableArmorItem;
                                return item.func_206844_a(AquacultureAPI.Tags.TACKLE_BOX) || item instanceof HookItem || item instanceof BaitItem || item.func_206844_a(AquacultureAPI.Tags.FISHING_LINE) && isDyeable || item.func_206844_a(AquacultureAPI.Tags.BOBBER) && isDyeable;
                            }
                        });
                    }
                }
            });
            for (int column = 0; column < 3; ++column) {
                for (int row = 0; row < 9; ++row) {
                    this.func_75146_a(new Slot((IInventory)playerInventory, row + column * 9 + 9, 8 + row * 18, 90 + column * 18));
                }
            }
            for (int row = 0; row < 9; ++row) {
                this.func_75146_a(new Slot((IInventory)playerInventory, row, 8 + row * 18, 148));
            }
        }
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return TackleBoxContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)Objects.requireNonNull(this.tackleBox.func_145831_w()), (BlockPos)this.tackleBox.func_174877_v()), (PlayerEntity)player, (Block)AquaBlocks.TACKLE_BOX);
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack transferStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            transferStack = slotStack.func_77946_l();
            if (index < this.rows * this.collumns ? !this.func_75135_a(slotStack, this.rows * this.collumns, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, this.rows * this.collumns, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return transferStack;
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (this.tackleBox != null) {
            this.tackleBox.closeInventory(player);
        }
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, PlayerEntity player) {
        SlotItemHandler slotHandler;
        Slot slot;
        if (slotId >= 0 && clickType == ClickType.PICKUP && (slot = (Slot)this.field_75151_b.get(slotId)) == this.slotBait && (slotHandler = (SlotItemHandler)slot).func_75214_a(player.field_71071_by.func_70445_o())) {
            slotHandler.func_75215_d(ItemStack.field_190927_a);
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }
}

