/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.items;

import com.teammetallurgy.aquaculture.items.AquacultureItems;
import com.teammetallurgy.aquaculture.loot.BiomeType;
import com.teammetallurgy.aquaculture.loot.FishLoot;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFish
extends Item {
    public List<Fish> fish;

    public ItemFish() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.fish = new ArrayList<Fish>();
    }

    public void addFish(String name, int filletAmount, int minWeight, int maxWeight, BiomeType biome, int rarity) {
        this.addFish(name, filletAmount, minWeight, maxWeight, new BiomeType[]{biome}, rarity);
    }

    public void addFish(String name, int filletAmount, int minWeight, int maxWeight, BiomeType[] biomes, int rarity) {
        this.fish.add(new Fish(name, filletAmount, minWeight, maxWeight));
        for (BiomeType biome : biomes) {
            FishLoot.instance().addFish(this.getItemStackFish(name), biome, rarity);
        }
    }

    public void addFilletRecipes() {
        for (int i = 0; i < this.fish.size(); ++i) {
            Fish f = this.fish.get(i);
            if (f.filletAmount == 0) continue;
            GameRegistry.addShapelessRecipe((ItemStack)AquacultureItems.fishFillet.getItemStack(f.filletAmount), (Object[])new Object[]{new ItemStack((Item)this, 1, i)});
        }
    }

    public String getItemDisplayName(ItemStack par1ItemStack) {
        if (par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74764_b("Prefix")) {
            return par1ItemStack.func_77978_p().func_74779_i("Prefix") + " " + super.func_77653_i(par1ItemStack);
        }
        return super.func_77653_i(par1ItemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> toolTip, boolean isDebug) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("Weight")) {
            float weight = itemStack.func_77978_p().func_74760_g("Weight");
            DecimalFormat df = new DecimalFormat("#,###.##");
            BigDecimal bd = new BigDecimal(weight);
            if ((bd = bd.round(new MathContext(3))).doubleValue() > 999.0) {
                toolTip.add("Weight: " + df.format((int)bd.doubleValue()) + "lb");
            } else {
                toolTip.add("Weight: " + bd + "lb");
            }
        }
    }

    public void assignRandomWeight(ItemStack stack, int heavyLineLvl) {
        if (stack == null) {
            return;
        }
        Fish f = this.fish.get(stack.func_77952_i());
        if (f.maxWeight == 1 && f.minWeight == 1) {
            return;
        }
        Random rand = new Random();
        float min = f.minWeight;
        min = (float)((double)min + (double)((float)f.maxWeight - min) * (0.1 * (double)heavyLineLvl));
        float weight = rand.nextFloat() * ((float)f.maxWeight * 1.1f - min) + min;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74776_a("Weight", weight);
        if ((double)weight <= (double)f.maxWeight / 10.0) {
            stack.func_77978_p().func_74778_a("Prefix", "Juvenile");
        }
        if (weight > (float)f.maxWeight) {
            stack.func_77978_p().func_74778_a("Prefix", "Massive");
        }
    }

    public ItemStack getItemStackFish(String name) {
        for (int i = 0; i < this.fish.size(); ++i) {
            if (!this.fish.get((int)i).name.equals(name)) continue;
            return new ItemStack((Item)this, 1, i);
        }
        return null;
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        int i = MathHelper.func_76125_a((int)par1ItemStack.func_77952_i(), (int)0, (int)this.fish.size());
        String uname = super.func_77658_a() + "." + this.fish.get((int)i).name;
        uname = uname.replace(" ", "_");
        return uname;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> subItems) {
        for (int j = 0; j < this.fish.size(); ++j) {
            subItems.add(new ItemStack(item, 1, j));
        }
    }

    public class Fish {
        public String name;
        public int filletAmount;
        public int minWeight;
        public int maxWeight;

        public Fish(String name, int amount, int min, int max) {
            this.name = name;
            this.filletAmount = amount;
            this.maxWeight = max;
            this.minWeight = min;
        }
    }
}

