/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.items.meta;

import com.teammetallurgy.aquaculture.items.meta.MetaItemFood;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;
import squeek.applecore.api.food.ItemFoodProxy;

@Optional.Interface(iface="squeek.applecore.api.food.IEdible", modid="AppleCore")
public class SubItemFood
implements IEdible {
    public int damage;
    public MetaItemFood item;
    public String unlocalizedName;
    public final int itemUseDuration;
    private final int healAmount;
    private final float saturationModifier;
    private final boolean isWolfsFavoriteMeat;
    private boolean alwaysEdible;
    private int potionId;
    private int potionDuration;
    private int potionAmplifier;
    private float potionEffectProbability;
    private int eatTime;

    public SubItemFood(MetaItemFood metaItem, int heal, float saturation, boolean isWolfFood) {
        this.item = metaItem;
        this.damage = this.item.addSubItem(this);
        this.itemUseDuration = 32;
        this.healAmount = heal;
        this.isWolfsFavoriteMeat = isWolfFood;
        this.saturationModifier = saturation;
        this.eatTime = 32;
    }

    public SubItemFood(MetaItemFood metaItem, int heal, boolean isWolfFood) {
        this(metaItem, heal, 0.6f, isWolfFood);
    }

    public SubItemFood setCreativeTab(CreativeTabs tab) {
        this.item.func_77637_a(tab);
        return this;
    }

    public SubItemFood setUnlocalizedName(String name) {
        this.unlocalizedName = name;
        return this;
    }

    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    public ItemStack getItemStack(int amount) {
        return new ItemStack((Item)this.item, amount, this.damage);
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        return this.unlocalizedName;
    }

    public SubItemFood setEatTime(int eatTime) {
        this.eatTime = eatTime;
        return this;
    }

    @Optional.Method(modid="AppleCore")
    public FoodValues getFoodValues(ItemStack itemStack) {
        return new FoodValues(this.getHealAmount(), this.getSaturationModifier());
    }

    @Optional.Method(modid="AppleCore")
    public void onEatenAppleCore(ItemStack itemStack, EntityPlayer player) {
        player.func_71024_bL().func_151686_a((ItemFood)new ItemFoodProxy((IEdible)this), itemStack);
    }

    public ItemStack onEaten(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        --par1ItemStack.field_77994_a;
        if (Loader.isModLoaded((String)"AppleCore")) {
            this.onEatenAppleCore(par1ItemStack, par3EntityPlayer);
        } else {
            par3EntityPlayer.func_71024_bL().func_75122_a(this.getHealAmount(), this.getSaturationModifier());
        }
        par2World.func_72956_a((Entity)par3EntityPlayer, "random.burp", 0.5f, par2World.field_73012_v.nextFloat() * 0.1f + 0.9f);
        this.onFoodEaten(par1ItemStack, par2World, par3EntityPlayer);
        return par1ItemStack;
    }

    protected void onFoodEaten(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!par2World.field_72995_K && this.potionId > 0 && par2World.field_73012_v.nextFloat() < this.potionEffectProbability) {
            par3EntityPlayer.func_70690_d(new PotionEffect(this.potionId, this.potionDuration * 20, this.potionAmplifier));
        }
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return this.eatTime;
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.EAT;
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (par3EntityPlayer.func_71043_e(this.alwaysEdible)) {
            par3EntityPlayer.func_71008_a(par1ItemStack, this.getMaxItemUseDuration(par1ItemStack));
        }
        return par1ItemStack;
    }

    public int getHealAmount() {
        return this.healAmount;
    }

    public float getSaturationModifier() {
        return this.saturationModifier;
    }

    public boolean isWolfsFavoriteMeat() {
        return this.isWolfsFavoriteMeat;
    }

    public SubItemFood setPotionEffect(int par1, int par2, int par3, float par4) {
        this.potionId = par1;
        this.potionDuration = par2;
        this.potionAmplifier = par3;
        this.potionEffectProbability = par4;
        return this;
    }

    public SubItemFood setAlwaysEdible() {
        this.alwaysEdible = true;
        return this;
    }
}

