/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery;

import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.auxiliary.CelestialGatewaySystem;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.base.ShootingStarHandler;
import hellfirepvp.astralsorcery.common.cmd.CommandAstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkEffectHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeTypeRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.data.DataPatreonFlares;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.ConfigDataAdapter;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.event.ClientInitializedEvent;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerEntity;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.util.JEISessionHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightTransmissionHandler;
import hellfirepvp.astralsorcery.common.util.PlayerActivityManager;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="astralsorcery", name="Astral Sorcery", version="1.10.26", dependencies="required-after:forge@[14.23.5.2781,);required-after:baubles;after:crafttweaker", guiFactory="hellfirepvp.astralsorcery.common.data.config.ingame.ConfigGuiFactory", certificateFingerprint="a0f0b759d895c15ceb3e3bcb5f3c2db7c582edf0", acceptedMinecraftVersions="[1.12.2]")
public class AstralSorcery {
    public static final String MODID = "astralsorcery";
    public static final String NAME = "Astral Sorcery";
    public static final String VERSION = "1.10.26";
    public static final String CLIENT_PROXY = "hellfirepvp.astralsorcery.client.ClientProxy";
    public static final String COMMON_PROXY = "hellfirepvp.astralsorcery.common.CommonProxy";
    private static boolean devEnvChache = false;
    @Mod.Instance(value="astralsorcery")
    public static AstralSorcery instance;
    public static Logger log;
    @SidedProxy(clientSide="hellfirepvp.astralsorcery.client.ClientProxy", serverSide="hellfirepvp.astralsorcery.common.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        event.getModMetadata().version = VERSION;
        devEnvChache = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        proxy.setupConfiguration();
        Config.loadAndSetup(event.getSuggestedConfigurationFile());
        proxy.registerConfigDataRegistries();
        Config.loadDataRegistries(event.getModConfigurationDirectory());
        Config.loadConfigRegistries(ConfigDataAdapter.LoadPhase.PRE_INIT);
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Config.loadConfigRegistries(ConfigDataAdapter.LoadPhase.INIT);
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Config.loadConfigRegistries(ConfigDataAdapter.LoadPhase.POST_INIT);
        proxy.postInit();
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        if (side == Side.SERVER) {
            boolean jeiFound = modList.containsKey(Mods.JEI.modid);
            if (Mods.JEI.isPresent()) {
                this.notifyServerConnection(jeiFound);
            }
        }
        return true;
    }

    @Optional.Method(modid="jei")
    private void notifyServerConnection(boolean jeiFound) {
        JEISessionHandler.getInstance().setJeiOnServer(jeiFound);
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandAstralSorcery());
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        CelestialGatewaySystem.instance.onServerStart();
    }

    @SubscribeEvent
    public void onClientFinish(ClientInitializedEvent event) {
        proxy.clientFinishedLoading();
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        ResearchManager.saveAndClearServerCache();
        StarlightTransmissionHandler.getInstance().serverCleanHandlers();
        PerkEffectHelper.perkCooldowns.clear();
        EventHandlerEntity.invulnerabilityCooldown.clear();
        EventHandlerEntity.ritualFlight.clear();
        EventHandlerEntity.attackStack.clear();
        EventHandlerEntity.spawnDenyRegions.clear();
        ((DataPatreonFlares)SyncDataHolder.getDataServer("PatreonFlares")).cleanUp(Side.SERVER);
        PerkAttributeHelper.clearServer();
        ShootingStarHandler.getInstance().clearServerCache();
        PlayerActivityManager.INSTANCE.clearCache(Side.SERVER);
    }

    @Mod.EventHandler
    public void onServerStop(FMLServerStoppedEvent event) {
        WorldCacheManager.wipeCache();
        AttributeTypeRegistry.getTypes().forEach(t -> t.clear(Side.SERVER));
        PerkTree.PERK_TREE.clearCache(Side.SERVER);
    }

    public static boolean isRunningInDevEnvironment() {
        return devEnvChache;
    }

    static {
        log = LogManager.getLogger((String)NAME);
        FluidRegistry.enableUniversalBucket();
    }
}

