/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.perk;

import hellfirepvp.astralsorcery.client.util.BufferBatch;
import hellfirepvp.astralsorcery.client.util.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BatchPerkContext {
    public static final int PRIORITY_BACKGROUND = 100;
    public static final int PRIORITY_FOREGROUND = 200;
    public static final int PRIORITY_OVERLAY = 300;
    private TreeMap<TextureObjectGroup, BufferBatch> bufferGroups = new TreeMap();

    public TextureObjectGroup addContext(AbstractRenderableTexture tex, int sortPriority) {
        TextureObjectGroup group = MiscUtils.iterativeSearch(this.bufferGroups.keySet(), gr -> gr.getResource().equals(tex));
        if (group == null) {
            group = new TextureObjectGroup(tex, sortPriority);
            this.bufferGroups.put(group, BufferBatch.make());
        }
        return group;
    }

    @Nonnull
    public BufferBatch getContext(TextureObjectGroup grp) {
        BufferBatch ctx = this.bufferGroups.get(grp);
        if (ctx == null) {
            throw new IllegalArgumentException("Unknown TextureGroup!");
        }
        return ctx;
    }

    public void draw() {
        for (TextureObjectGroup group : this.bufferGroups.keySet()) {
            BufferBatch batch = this.bufferGroups.get(group);
            group.getResource().bindTexture();
            batch.draw();
        }
    }

    public void beginDrawingPerks() {
        for (TextureObjectGroup group : this.bufferGroups.keySet()) {
            this.bufferGroups.get(group).getBuffer().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        }
    }

    public class TextureObjectGroup
    implements Comparable<TextureObjectGroup> {
        private final AbstractRenderableTexture resource;
        private final int priority;

        private TextureObjectGroup(AbstractRenderableTexture resource, int priority) {
            this.resource = resource;
            this.priority = priority;
        }

        public AbstractRenderableTexture getResource() {
            return this.resource;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextureObjectGroup that = (TextureObjectGroup)o;
            return Objects.equals(this.resource, that.resource);
        }

        public int hashCode() {
            return Objects.hash(this.resource);
        }

        @Override
        public int compareTo(TextureObjectGroup o) {
            return Integer.compare(this.priority, o.priority);
        }
    }
}

