/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util.obj;

import hellfirepvp.astralsorcery.client.util.obj.TextureCoordinate;
import hellfirepvp.astralsorcery.client.util.obj.Vertex;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Face {
    public Vertex[] vertices;
    public Vertex[] vertexNormals;
    public TextureCoordinate[] textureCoordinates;

    @SideOnly(value=Side.CLIENT)
    public void addFaceForRender(BufferBuilder vb) {
        this.addFaceForRender(vb, 5.0E-4f);
    }

    @SideOnly(value=Side.CLIENT)
    public void addFaceForRender(BufferBuilder vb, float textureOffset) {
        float averageU = 0.0f;
        float averageV = 0.0f;
        if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
            for (int i = 0; i < this.textureCoordinates.length; ++i) {
                averageU += this.textureCoordinates[i].u;
                averageV += this.textureCoordinates[i].v;
            }
            averageU /= (float)this.textureCoordinates.length;
            averageV /= (float)this.textureCoordinates.length;
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
                float offsetU = textureOffset;
                float offsetV = textureOffset;
                if (this.textureCoordinates[i].u > averageU) {
                    offsetU = -offsetU;
                }
                if (this.textureCoordinates[i].v > averageV) {
                    offsetV = -offsetV;
                }
                vb.func_181662_b((double)this.vertices[i].x, (double)this.vertices[i].y, (double)this.vertices[i].z).func_187315_a((double)(this.textureCoordinates[i].u + offsetU), (double)(this.textureCoordinates[i].v + offsetV)).func_181675_d();
                continue;
            }
            vb.func_181662_b((double)this.vertices[i].x, (double)this.vertices[i].y, (double)this.vertices[i].z).func_181675_d();
        }
    }

    public Vertex calculateFaceNormal() {
        Vector3 v1 = new Vector3(this.vertices[1].x - this.vertices[0].x, this.vertices[1].y - this.vertices[0].y, this.vertices[1].z - this.vertices[0].z);
        Vector3 v2 = new Vector3(this.vertices[2].x - this.vertices[0].x, this.vertices[2].y - this.vertices[0].y, this.vertices[2].z - this.vertices[0].z);
        Vector3 normalVector = v1.crossProduct(v2).normalize();
        return new Vertex((float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ());
    }
}

