/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary.tick;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.event.ClientInitializedEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TickManager {
    private static boolean firedFirstTick = false;
    private static final TickManager instance = new TickManager();
    private Map<TickEvent.Type, List<ITickHandler>> registeredTickHandlers = new HashMap<TickEvent.Type, List<ITickHandler>>();

    private TickManager() {
        for (TickEvent.Type type : TickEvent.Type.values()) {
            this.registeredTickHandlers.put(type, new LinkedList());
        }
    }

    public static TickManager getInstance() {
        return instance;
    }

    public void register(ITickHandler handler) {
        for (TickEvent.Type type : handler.getHandledTypes()) {
            this.registeredTickHandlers.get(type).add(handler);
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        TickEvent.Phase ph = event.phase;
        for (ITickHandler handler : this.registeredTickHandlers.get(TickEvent.Type.WORLD)) {
            if (!handler.canFire(ph)) continue;
            handler.tick(TickEvent.Type.WORLD, event.world);
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        TickEvent.Phase ph = event.phase;
        for (ITickHandler handler : this.registeredTickHandlers.get(TickEvent.Type.SERVER)) {
            if (!handler.canFire(ph)) continue;
            handler.tick(TickEvent.Type.SERVER, new Object[0]);
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        TickEvent.Phase ph = event.phase;
        for (ITickHandler handler : this.registeredTickHandlers.get(TickEvent.Type.CLIENT)) {
            if (!handler.canFire(ph)) continue;
            handler.tick(TickEvent.Type.CLIENT, new Object[0]);
        }
        if (!firedFirstTick) {
            firedFirstTick = true;
            MinecraftForge.EVENT_BUS.post((Event)new ClientInitializedEvent());
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        TickEvent.Phase ph = event.phase;
        for (ITickHandler handler : this.registeredTickHandlers.get(TickEvent.Type.RENDER)) {
            if (!handler.canFire(ph)) continue;
            handler.tick(TickEvent.Type.RENDER, Float.valueOf(event.renderTickTime));
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        TickEvent.Phase ph = event.phase;
        for (ITickHandler handler : this.registeredTickHandlers.get(TickEvent.Type.PLAYER)) {
            if (!handler.canFire(ph)) continue;
            handler.tick(TickEvent.Type.PLAYER, event.player, event.side);
        }
    }
}

