/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.entity;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingSprite;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.RowSpriteSheetResource;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.client.util.resource.TextureQuery;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.base.patreon.entity.EffectFloatingCrystal;
import hellfirepvp.astralsorcery.common.base.patreon.flare.PatreonPartialEntity;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.UUID;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PartialEntityFlareCrystal
extends PatreonPartialEntity {
    private TextureQuery queryTexture = new TextureQuery(AssetLoader.TextureLocation.MODELS, "crystal_big_blue");
    private Color colorTheme = Color.WHITE;
    private final PatreonEffectHelper.FlareColor flareColor;
    private Object crystalEffect = null;
    private Object flareEffect = null;

    public PartialEntityFlareCrystal(PatreonEffectHelper.FlareColor flareColor, UUID ownerUUID) {
        super(ownerUUID);
        this.flareColor = flareColor;
    }

    public PartialEntityFlareCrystal setQueryTexture(TextureQuery queryTexture) {
        this.queryTexture = queryTexture;
        return this;
    }

    public PartialEntityFlareCrystal setColorTheme(Color colorTheme) {
        this.colorTheme = colorTheme;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void spawnEffects() {
        super.spawnEffects();
        if (rand.nextBoolean() || !Config.enablePatreonEffects) {
            return;
        }
        int age = 30 + rand.nextInt(15);
        float scale = 0.1f + rand.nextFloat() * 0.1f;
        Vector3 at = new Vector3(this.pos);
        at.add((double)rand.nextFloat() * 0.15 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.15 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.15 * (double)(rand.nextBoolean() ? 1 : -1));
        EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(at);
        particle.scale(scale).gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
        particle.setColor(rand.nextInt(3) == 0 ? this.flareColor.color2 : this.flareColor.color1);
        particle.setMaxAge(age);
        if (rand.nextBoolean()) {
            particle = EffectHelper.genericFlareParticle(at);
            particle.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            particle.scale(scale * 0.3f).gravity(0.004);
            particle.setMaxAge(age - 10);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private SpriteSheetResource getSprite() {
        return RowSpriteSheetResource.crop(this.flareColor.getTexture(), this.flareColor.spriteRowIndex());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void tickInRenderDistance() {
        EntityFXFacingSprite p;
        EffectFloatingCrystal crystal;
        super.tickInRenderDistance();
        if (this.crystalEffect != null) {
            crystal = (EffectFloatingCrystal)this.crystalEffect;
            if (crystal.isRemoved() && Config.enablePatreonEffects) {
                EffectHandler.getInstance().registerFX(crystal);
            }
        } else {
            crystal = new EffectFloatingCrystal();
            crystal.setPositionUpdateFunction((fx, v, m) -> this.getPos());
            crystal.setRefreshFunc(() -> !this.removed && Config.enablePatreonEffects);
            crystal.setTexture(this.queryTexture);
            crystal.setColorTheme(this.colorTheme);
            EffectHandler.getInstance().registerFX(crystal);
            this.crystalEffect = crystal;
        }
        if (this.flareEffect != null) {
            p = (EntityFXFacingSprite)this.flareEffect;
            if (p.isRemoved() && Config.enablePatreonEffects) {
                EffectHandler.getInstance().registerFX(p);
            }
        } else {
            p = EntityFXFacingSprite.fromSpriteSheet(this.getSprite(), this.pos.getX(), this.pos.getY(), this.pos.getZ(), 0.75f, 0);
            p.setPositionUpdateFunction((fx, v, m) -> this.getPos().addY(0.2));
            p.setRefreshFunc(() -> !this.removed && Config.enablePatreonEffects);
            EffectHandler.getInstance().registerFX(p);
            this.flareEffect = p;
        }
    }
}

