/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.cape.impl;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeArmorEffect;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.util.DamageUtil;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CapeEffectEvorsio
extends CapeArmorEffect {
    private static float percDamageAppliedNearby = 0.5f;
    private static float rangeDeathAOE = 4.0f;

    public CapeEffectEvorsio(NBTTagCompound cmp) {
        super(cmp, "evorsio");
    }

    @Override
    public IConstellation getAssociatedConstellation() {
        return Constellations.evorsio;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playActiveParticleTick(EntityPlayer pl) {
        this.playConstellationCapeSparkles(pl, 0.15f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playBlockBreakParticles(PktParticleEvent event) {
        int stateId;
        IBlockState state;
        Vector3 at = event.getVec();
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_() && event.getAdditionalDataLong() != 0L && (state = Block.func_176220_d((int)(stateId = (int)event.getAdditionalDataLong()))) != Blocks.field_150350_a.func_176223_P()) {
            ParticleManager pm = Minecraft.func_71410_x().field_71452_i;
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            try {
                if (!state.func_177230_c().addDestroyEffects((World)world, at.toBlockPos(), pm)) {
                    RenderingUtils.playBlockBreakParticles(at.toBlockPos(), state);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (int i = 0; i < 4; ++i) {
            double x = at.getX() + (double)rand.nextFloat();
            double y = at.getY() + (double)rand.nextFloat();
            double z = at.getZ() + (double)rand.nextFloat();
            float scale = rand.nextFloat() * 0.2f + 0.3f;
            float mX = rand.nextFloat() * 0.01f * (float)(rand.nextBoolean() ? 1 : -1);
            float mY = rand.nextFloat() * 0.01f * (float)(rand.nextBoolean() ? 1 : -1);
            float mZ = rand.nextFloat() * 0.01f * (float)(rand.nextBoolean() ? 1 : -1);
            Color c = Constellations.evorsio.getConstellationColor();
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(x, y, z);
            p.setColor(c).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(scale);
            if (rand.nextInt(6) == 0) {
                p.setColor(IConstellation.weak);
            }
            p.setMaxAge(30 + rand.nextInt(10));
            p.motion(mX, mY, mZ);
            if (!(rand.nextFloat() < 0.4f)) continue;
            p = EffectHelper.genericFlareParticle(x, y, z);
            p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(scale * 0.35f);
            p.setMaxAge(20 + rand.nextInt(10));
            p.motion(mX, mY, mZ);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void playAreaDamageParticles(PktParticleEvent event) {
        EntityFXFacingParticle p;
        float scale;
        Vector3 mov;
        Vector3 off;
        Vector3 dir;
        int i;
        Vector3 offset = event.getVec();
        Color c = Constellations.evorsio.getConstellationColor();
        for (i = 0; i < 45; ++i) {
            dir = Vector3.random();
            dir.setY(dir.getY() * (double)0.2f).normalize().multiply(rangeDeathAOE / 2.0f);
            off = dir.clone().multiply(0.1f + rand.nextFloat() * 0.4f);
            mov = dir.clone().multiply(0.01f);
            scale = rand.nextFloat() * 0.2f + 0.2f;
            p = EffectHelper.genericFlareParticle(offset.getX() + off.getX(), offset.getY() + off.getY(), offset.getZ() + off.getZ());
            p.setColor(c).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(scale);
            p.setMaxAge(30 + rand.nextInt(10));
            p.motion(mov.getX(), mov.getY(), mov.getZ());
            if (!(rand.nextFloat() < 0.4f)) continue;
            p = EffectHelper.genericFlareParticle(offset.getX() + off.getX(), offset.getY() + off.getY(), offset.getZ() + off.getZ());
            p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(scale * 0.35f);
            p.setMaxAge(20 + rand.nextInt(10));
            p.motion(mov.getX(), mov.getY(), mov.getZ());
        }
        for (i = 0; i < 65; ++i) {
            dir = Vector3.random();
            dir.setY(dir.getY() * (double)0.3f).normalize().multiply(rangeDeathAOE / 2.0f);
            off = dir.clone().multiply(0.5f + rand.nextFloat() * 0.4f);
            mov = dir.clone().multiply(0.015f);
            scale = rand.nextFloat() * 0.2f + 0.2f;
            p = EffectHelper.genericFlareParticle(offset.getX() + off.getX(), offset.getY() + off.getY(), offset.getZ() + off.getZ());
            p.setColor(IConstellation.weak).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(scale);
            p.setMaxAge(30 + rand.nextInt(10));
            p.motion(mov.getX(), mov.getY(), mov.getZ());
            if (!(rand.nextFloat() < 0.4f)) continue;
            p = EffectHelper.genericFlareParticle(offset.getX() + off.getX(), offset.getY() + off.getY(), offset.getZ() + off.getZ());
            p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(scale * 0.35f);
            p.setMaxAge(20 + rand.nextInt(10));
            p.motion(mov.getX(), mov.getY(), mov.getZ());
        }
    }

    public void deathAreaDamage(DamageSource ds, EntityLivingBase entityLiving) {
        if (percDamageAppliedNearby > 0.0f) {
            float damage = entityLiving.func_110138_aP() * percDamageAppliedNearby;
            float r = rangeDeathAOE;
            List eList = entityLiving.field_70170_p.func_175647_a(EntityLivingBase.class, new AxisAlignedBB((double)(-r), (double)(-r), (double)(-r), (double)r, (double)r, (double)r).func_186670_a(entityLiving.func_180425_c()), e -> e != null && !e.field_70128_L && e.func_110143_aJ() > 0.0f && e.isCreatureType(EnumCreatureType.MONSTER, false));
            for (EntityLivingBase el : eList) {
                int preTime = el.field_70172_ad;
                el.field_70172_ad = 0;
                DamageUtil.attackEntityFrom((Entity)el, ds, damage);
                el.field_70172_ad = Math.max(preTime, el.field_70172_ad);
            }
            PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.CAPE_EVORSIO_AOE, Vector3.atEntityCenter((Entity)entityLiving));
            PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(entityLiving.field_70170_p, (Vec3i)entityLiving.func_180425_c(), 16.0));
        }
    }

    public void breakBlocksPlaneVertical(EntityPlayerMP player, EnumFacing sideBroken, World world, BlockPos at) {
        for (int xx = -2; xx <= 2; ++xx) {
            if (sideBroken.func_176730_m().func_177958_n() != 0 && xx != 0) continue;
            for (int yy = -1; yy <= 3; ++yy) {
                if (sideBroken.func_176730_m().func_177956_o() != 0 && yy != 0) continue;
                for (int zz = -2; zz <= 2; ++zz) {
                    BlockPos other;
                    if (sideBroken.func_176730_m().func_177952_p() != 0 && zz != 0 || world.func_175625_s(other = at.func_177982_a(xx, yy, zz)) != null || world.func_180495_p(other).func_185887_b(world, other) == -1.0f) continue;
                    IBlockState present = world.func_180495_p(other);
                    if (!MiscUtils.breakBlockWithPlayer(other, player)) continue;
                    PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.CAPE_EVORSIO_BREAK, (Vec3i)other);
                    ev.setAdditionalDataLong(Block.func_176210_f((IBlockState)present));
                    PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(world, (Vec3i)other, 16.0));
                }
            }
        }
    }

    public void breakBlocksPlaneHorizontal(EntityPlayerMP player, EnumFacing sideBroken, World world, BlockPos at) {
        for (int xx = -2; xx <= 2; ++xx) {
            if (sideBroken.func_176730_m().func_177958_n() != 0 && xx != 0) continue;
            for (int zz = -2; zz <= 2; ++zz) {
                BlockPos other;
                if (sideBroken.func_176730_m().func_177952_p() != 0 && zz != 0 || world.func_175625_s(other = at.func_177982_a(xx, 0, zz)) != null || world.func_180495_p(other).func_185887_b(world, other) == -1.0f) continue;
                IBlockState present = world.func_180495_p(other);
                if (!MiscUtils.breakBlockWithPlayer(other, player)) continue;
                PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.CAPE_EVORSIO_BREAK, (Vec3i)other);
                ev.setAdditionalDataLong(Block.func_176210_f((IBlockState)present));
                PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(world, (Vec3i)other, 16.0));
            }
        }
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        percDamageAppliedNearby = cfg.getFloat(this.getKey() + "PercentLifeDamage", this.getConfigurationSection(), percDamageAppliedNearby, 0.0f, 10.0f, "Defines the multiplier how much of the dead entity's max-life should be dealt as AOE damage to mobs nearby.");
        rangeDeathAOE = cfg.getFloat(this.getKey() + "DeathAOERange", this.getConfigurationSection(), rangeDeathAOE, 0.5f, 50.0f, "Defines the Range of the death-AOE effect of when a mob gets killed by a player with this cape on.");
    }
}

