/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.constellation;

import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.constellation.ConstellationPerk;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import net.minecraft.entity.player.EntityPlayer;

public class PerkUlteria
extends ConstellationPerk {
    public PerkUlteria(int x, int y) {
        super("cst_ulteria", Constellations.ulteria, x, y);
        this.setCategory(CATEGORY_FOCUS);
        final float perPoint = 0.05f;
        this.addModifier(new PerkAttributeModifier("astralsorcery.expgain", PerkAttributeModifier.Mode.STACKING_MULTIPLY, 1.0f + perPoint){

            @Override
            protected void initModifier() {
                super.initModifier();
                this.setAbsolute();
            }

            @Override
            public float getValue(EntityPlayer player, PlayerProgress progress) {
                return 1.0f + perPoint * (float)progress.getAvailablePerkPoints(player);
            }

            @Override
            public boolean hasDisplayString() {
                return false;
            }
        });
    }

    @Override
    public boolean mayUnlockPerk(PlayerProgress progress, EntityPlayer player) {
        return super.mayUnlockPerk(progress, player) && !MiscUtils.contains(progress.getAppliedPerks(), perk -> perk.getCategory().equals(CATEGORY_FOCUS));
    }
}

