/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.grindstone;

import hellfirepvp.astralsorcery.common.crafting.grindstone.CrystalSharpeningRecipe;
import hellfirepvp.astralsorcery.common.crafting.grindstone.CrystalToolSharpeningRecipe;
import hellfirepvp.astralsorcery.common.crafting.grindstone.GrindstoneRecipe;
import hellfirepvp.astralsorcery.common.crafting.grindstone.SwordSharpeningRecipe;
import hellfirepvp.astralsorcery.common.util.ItemComparator;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class GrindstoneRecipeRegistry {
    private static final Random rand = new Random();
    public static List<GrindstoneRecipe> recipes = new LinkedList<GrindstoneRecipe>();
    public static List<GrindstoneRecipe> mtRecipes = new LinkedList<GrindstoneRecipe>();
    private static List<GrindstoneRecipe> localFallback = new LinkedList<GrindstoneRecipe>();

    public static GrindstoneRecipe registerGrindstoneRecipe(ItemStack in, ItemStack out, int chance) {
        return GrindstoneRecipeRegistry.registerGrindstoneRecipe(new GrindstoneRecipe(in, out, chance));
    }

    public static GrindstoneRecipe registerGrindstoneRecipe(GrindstoneRecipe recipe) {
        recipes.add(recipe);
        return recipe;
    }

    public static Collection<GrindstoneRecipe> getValidRecipes() {
        return recipes.stream().filter(GrindstoneRecipe::isValid).filter(r -> !(r instanceof CrystalToolSharpeningRecipe) && !(r instanceof CrystalSharpeningRecipe) && !(r instanceof SwordSharpeningRecipe)).collect(Collectors.toList());
    }

    public static GrindstoneRecipe tryRemoveGrindstoneRecipe(ItemStack matchOut) {
        for (GrindstoneRecipe gr : recipes) {
            if (!gr.isValid() || !ItemComparator.compare(gr.getOutputForMatching(), matchOut, ItemComparator.Clause.ITEM, ItemComparator.Clause.META_STRICT)) continue;
            recipes.remove(gr);
            return gr;
        }
        return null;
    }

    public static void cacheLocalFallback() {
        if (localFallback.isEmpty()) {
            localFallback.addAll(recipes);
        }
    }

    public static void loadFromFallback() {
        recipes.clear();
        recipes.addAll(localFallback);
    }

    @Nullable
    public static GrindstoneRecipe findMatchingRecipe(ItemStack stackIn) {
        LinkedList<GrindstoneRecipe> matching = new LinkedList<GrindstoneRecipe>();
        for (GrindstoneRecipe gr : recipes) {
            if (!gr.isValid() || !gr.matches(stackIn)) continue;
            matching.add(gr);
        }
        for (GrindstoneRecipe gr : mtRecipes) {
            if (!gr.isValid() || !gr.matches(stackIn)) continue;
            matching.add(gr);
        }
        if (matching.isEmpty()) {
            return null;
        }
        return (GrindstoneRecipe)matching.get(rand.nextInt(matching.size()));
    }
}

