/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.jei.util;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.container.ContainerAltarBase;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.util.JEISessionHandler;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.network.packets.PacketJei;
import mezz.jei.network.packets.PacketRecipeTransfer;
import mezz.jei.startup.StackHelper;
import mezz.jei.util.Log;
import mezz.jei.util.Translator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class TieredAltarRecipeTransferHandler<C extends ContainerAltarBase>
implements IRecipeTransferHandler<C> {
    private static final int FILL_CONTAINER_SIZE = 25;
    private static final Tuple<Integer, Integer>[] mirrorMapping = new Tuple[]{new Tuple<Integer, Integer>(2, 4), new Tuple<Integer, Integer>(3, 7), new Tuple<Integer, Integer>(6, 8)};
    private final Class<C> containerClass;
    private final StackHelper stackHelper;
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final int maxListSize;

    public TieredAltarRecipeTransferHandler(Class<C> containerClass, StackHelper stackHelper, IRecipeTransferHandlerHelper handlerHelper, int maxListSize) {
        this.containerClass = containerClass;
        this.stackHelper = stackHelper;
        this.handlerHelper = handlerHelper;
        this.maxListSize = maxListSize;
    }

    public Class<C> getContainerClass() {
        return this.containerClass;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(C container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        ItemStack stack;
        if (!JEISessionHandler.getInstance().isJeiOnServer()) {
            String tooltipMessage = Translator.translateToLocal((String)"jei.tooltip.error.recipe.transfer.no.server");
            return this.handlerHelper.createUserErrorWithTooltip(tooltipMessage);
        }
        if (!this.containerClass.isAssignableFrom(container.getClass())) {
            return this.handlerHelper.createInternalError();
        }
        HashMap<Integer, Slot> inventorySlots = new HashMap<Integer, Slot>();
        for (Object slot : ((ContainerAltarBase)((Object)container)).field_75151_b.subList(0, 36)) {
            inventorySlots.put(((Slot)slot).field_75222_d, (Slot)slot);
        }
        HashMap<Integer, Slot> craftingSlots = new HashMap<Integer, Slot>();
        for (Slot slot : ((ContainerAltarBase)((Object)container)).field_75151_b.subList(36, 36 + this.maxListSize)) {
            craftingSlots.put(slot.field_75222_d, slot);
        }
        int inputCount = 0;
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        HashMap itemGroup = Maps.newHashMap((Map)itemStackGroup.getGuiIngredients());
        Iterator iterator = itemGroup.keySet().iterator();
        while (iterator.hasNext()) {
            Integer slotId = (Integer)iterator.next();
            if (slotId > craftingSlots.size()) {
                iterator.remove();
                continue;
            }
            IGuiIngredient ingredient = (IGuiIngredient)itemGroup.get(slotId);
            if (!ingredient.isInput() || ingredient.getAllIngredients().isEmpty()) continue;
            ++inputCount;
        }
        if (inputCount > craftingSlots.size()) {
            Log.get().error("Recipe Transfer helper {} does not work for container {}", this.containerClass, container.getClass());
            return this.handlerHelper.createInternalError();
        }
        HashMap<Integer, ItemStack> availableItemStacks = new HashMap<Integer, ItemStack>();
        int filledCraftSlotCount = 0;
        int emptySlotCount = 0;
        for (Slot slot : craftingSlots.values()) {
            stack = slot.func_75211_c();
            if (stack.func_190926_b()) continue;
            if (!slot.func_82869_a(player)) {
                Log.get().error("Recipe Transfer helper {} does not work for container {}. Player can't move item out of Crafting Slot number {}", this.containerClass, container.getClass(), (Object)slot.field_75222_d);
                return this.handlerHelper.createInternalError();
            }
            ++filledCraftSlotCount;
            availableItemStacks.put(slot.field_75222_d, stack.func_77946_l());
        }
        for (Slot slot : inventorySlots.values()) {
            stack = slot.func_75211_c();
            if (!stack.func_190926_b()) {
                availableItemStacks.put(slot.field_75222_d, stack.func_77946_l());
                continue;
            }
            ++emptySlotCount;
        }
        if (filledCraftSlotCount - inputCount > emptySlotCount) {
            String message = Translator.translateToLocal((String)"jei.tooltip.error.recipe.transfer.inventory.full");
            return this.handlerHelper.createUserErrorWithTooltip(message);
        }
        StackHelper.MatchingItemsResult matchingItemsResult = this.stackHelper.getMatchingItems(availableItemStacks, (Map)itemGroup);
        if (matchingItemsResult.missingItems.size() > 0) {
            String message = Translator.translateToLocal((String)"jei.tooltip.error.recipe.transfer.missing");
            return this.handlerHelper.createUserErrorForSlots(message, (Collection)matchingItemsResult.missingItems);
        }
        ArrayList<Integer> craftingSlotIndexes = new ArrayList<Integer>(craftingSlots.keySet());
        Collections.sort(craftingSlotIndexes);
        ArrayList inventorySlotIndexes = new ArrayList(inventorySlots.keySet());
        Collections.sort(inventorySlotIndexes);
        for (Map.Entry entry : matchingItemsResult.matchingItems.entrySet()) {
            int craftNumber = (Integer)entry.getKey();
            int slotNumber = (Integer)craftingSlotIndexes.get(craftNumber);
            if (slotNumber >= 0 && slotNumber < ((ContainerAltarBase)((Object)container)).field_75151_b.size()) continue;
            Log.get().error("Recipes Transfer Helper {} references slot {} outside of the inventory's size {}", this.containerClass, (Object)slotNumber, (Object)((ContainerAltarBase)((Object)container)).field_75151_b.size());
            return this.handlerHelper.createInternalError();
        }
        this.mirrorGrid(craftingSlotIndexes);
        HashMap slotMap = Maps.newHashMap((Map)matchingItemsResult.matchingItems);
        this.mirrorSlotGrid(slotMap);
        if (doTransfer) {
            PacketRecipeTransfer packet = new PacketRecipeTransfer((Map)slotMap, craftingSlotIndexes, inventorySlotIndexes, maxTransfer, true);
            JustEnoughItems.getProxy().sendPacketToServer((PacketJei)packet);
        }
        return null;
    }

    private void mirrorSlotGrid(Map<Integer, Integer> slotMap) {
        for (Tuple<Integer, Integer> mirrorPair : mirrorMapping) {
            if (slotMap.containsKey(mirrorPair.key)) {
                Integer keyCache = slotMap.get(mirrorPair.key);
                if (slotMap.containsKey(mirrorPair.value)) {
                    slotMap.put((Integer)mirrorPair.key, slotMap.remove(mirrorPair.value));
                } else {
                    slotMap.remove(mirrorPair.key);
                }
                slotMap.put((Integer)mirrorPair.value, keyCache);
                continue;
            }
            if (!slotMap.containsKey(mirrorPair.value)) continue;
            slotMap.put((Integer)mirrorPair.key, slotMap.remove(mirrorPair.value));
        }
    }

    private void mirrorGrid(List<Integer> slotIndexes) {
        for (Tuple<Integer, Integer> mirrorPair : mirrorMapping) {
            Integer slotFrom = slotIndexes.get((Integer)mirrorPair.key);
            slotIndexes.set((Integer)mirrorPair.key, slotIndexes.get((Integer)mirrorPair.value));
            slotIndexes.set((Integer)mirrorPair.value, slotFrom);
        }
    }
}

