/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.crystal;

import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class ToolCrystalProperties
extends CrystalProperties {
    public ToolCrystalProperties(int size, int purity, int collectiveCapability, int fracturation, int sizeOverride) {
        super(size, purity, collectiveCapability, fracturation, sizeOverride);
    }

    public static ToolCrystalProperties merge(CrystalProperties ... properties) {
        return ToolCrystalProperties.merge(Arrays.asList(properties));
    }

    public static ToolCrystalProperties merge(List<CrystalProperties> properties) {
        int totalSize = 0;
        int totalPurity = 0;
        int totalCollectivity = 0;
        int frac = 0;
        int ovr = 0;
        for (CrystalProperties c : properties) {
            totalSize += c.getSize();
            totalPurity += c.getPurity();
            totalCollectivity += c.getCollectiveCapability();
            frac += c.getFracturation();
            if (c.getSizeOverride() < 0) continue;
            ovr += c.getSizeOverride() - 900;
        }
        if (ovr != 0) {
            ovr /= properties.size();
            ovr += 900 * properties.size();
        } else {
            ovr = -1;
        }
        return new ToolCrystalProperties(totalSize, totalPurity / properties.size(), totalCollectivity / properties.size(), frac / properties.size(), ovr);
    }

    public static ToolCrystalProperties readFromNBT(NBTTagCompound compound) {
        ToolCrystalProperties prop = new ToolCrystalProperties(0, 0, 0, 0, -1);
        prop.size = compound.func_74762_e("size");
        prop.purity = compound.func_74762_e("purity");
        prop.collectiveCapability = compound.func_74762_e("collect");
        prop.fractured = compound.func_74762_e("fract");
        prop.sizeOverride = NBTHelper.getInteger(compound, "sizeOverride", -1);
        return prop;
    }

    public ToolCrystalProperties copyDamagedCutting() {
        return new ToolCrystalProperties(this.size, this.purity, Math.max(0, this.collectiveCapability - 1), this.fractured, this.sizeOverride);
    }

    @Override
    @Nullable
    public ToolCrystalProperties grindCopy(Random rand) {
        CrystalProperties out = super.grindCopy(rand);
        if (out == null) {
            return null;
        }
        return new ToolCrystalProperties(out.size, out.purity, out.collectiveCapability, out.fractured, out.sizeOverride);
    }

    public float getEfficiencyMultiplier() {
        float mult = (float)this.collectiveCapability / 100.0f;
        return Math.max(0.05f, (float)Math.sqrt(mult));
    }
}

