/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.network;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class StarlightUpdateHandler
implements ITickHandler {
    private static final StarlightUpdateHandler instance = new StarlightUpdateHandler();
    private static Map<Integer, List<IPrismTransmissionNode>> updateRequired = new HashMap<Integer, List<IPrismTransmissionNode>>();
    private static final Object accessLock = new Object();

    private StarlightUpdateHandler() {
    }

    public static StarlightUpdateHandler getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        World world = (World)context[0];
        if (world.field_72995_K) {
            return;
        }
        List<IPrismTransmissionNode> nodes = this.getNodes(world);
        Object object = accessLock;
        synchronized (object) {
            for (IPrismTransmissionNode node : nodes) {
                node.update(world);
            }
        }
    }

    private List<IPrismTransmissionNode> getNodes(World world) {
        int dimId = world.field_73011_w.getDimension();
        List<IPrismTransmissionNode> nodes = updateRequired.get(dimId);
        if (nodes == null) {
            nodes = new LinkedList<IPrismTransmissionNode>();
            updateRequired.put(dimId, nodes);
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(World world, IPrismTransmissionNode node) {
        Object object = accessLock;
        synchronized (object) {
            this.getNodes(world).remove(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(World world, IPrismTransmissionNode node) {
        Object object = accessLock;
        synchronized (object) {
            this.getNodes(world).add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informWorldLoad(World world) {
        Object object = accessLock;
        synchronized (object) {
            updateRequired.remove(world.field_73011_w.getDimension());
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.WORLD);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "Starlight Update Handler";
    }
}

