/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.StructureGenBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;

public class StructureFinder {
    public static final String STRUCT_VILLAGE = "Village";
    public static final String STRUCT_STRONGHOLD = "Stronghold";
    public static final String STRUCT_MASNION = "Mansion";
    public static final String STRUCT_MONUMENT = "Monument";
    public static final String STRUCT_MINESHAFT = "Mineshaft";
    public static final String STRUCT_TEMPLE = "Temple";
    public static final String STRUCT_ENDCITY = "EndCity";
    public static final String STRUCT_FORTRESS = "Fortress";

    private StructureFinder() {
    }

    @Nullable
    public static BlockPos tryFindClosestAstralSorceryStructure(WorldServer world, BlockPos playerPos, StructureGenBuffer.StructureType searchKey) {
        StructureGenBuffer buffer = (StructureGenBuffer)WorldCacheManager.getOrLoadData((World)world, WorldCacheManager.SaveKey.STRUCTURE_GEN);
        return buffer.getClosest(searchKey, playerPos);
    }

    @Nullable
    public static BlockPos tryFindClosestVanillaStructure(WorldServer world, BlockPos playerPos, String searchKey) {
        IChunkGenerator gen = world.func_72863_F().field_186029_c;
        if (gen == null) {
            return null;
        }
        try {
            return gen.func_180513_a((World)world, searchKey, playerPos, true);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Nullable
    public static BlockPos tryFindClosestBiomeType(WorldServer world, BlockPos playerPos, BiomeDictionary.Type biomeType) {
        ArrayList fitting = Lists.newArrayList((Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)biomeType));
        if (fitting.isEmpty()) {
            return null;
        }
        BiomeProvider gen = world.func_72959_q();
        for (int reach = 64; reach < 2112; reach += 128) {
            BlockPos closest = gen.func_180630_a(playerPos.func_177958_n(), playerPos.func_177952_p(), reach, (List)fitting, new Random(world.func_72905_C()));
            if (closest == null) continue;
            return closest;
        }
        return null;
    }
}

