/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.data;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.util.data.TokenizedMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TickTokenizedMap<K, V extends TickMapToken<?>>
extends TokenizedMap<K, V>
implements ITickHandler {
    private EnumSet<TickEvent.Type> tickTypes;

    public TickTokenizedMap(@Nonnull TickEvent.Type first, TickEvent.Type ... restTypes) {
        this.tickTypes = EnumSet.of(first, restTypes);
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        Iterator iteratorEntries = this.entrySet().iterator();
        while (iteratorEntries.hasNext()) {
            Map.Entry entry = iteratorEntries.next();
            ((TickMapToken)entry.getValue()).tick();
            if (((TickMapToken)entry.getValue()).getRemainingTimeout() > 0) continue;
            ((TickMapToken)entry.getValue()).onTimeout();
            iteratorEntries.remove();
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return this.tickTypes;
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "TickTokenMap";
    }

    public static interface TickMapToken<E>
    extends TokenizedMap.MapToken<E> {
        public int getRemainingTimeout();

        public void tick();

        public void onTimeout();
    }

    public static class SimpleTickToken<E>
    implements TickMapToken<E> {
        @Nonnull
        private E value;
        private int timeout;

        public SimpleTickToken(@Nonnull E value, int initialTimeout) {
            this.value = value;
            this.timeout = initialTimeout;
        }

        @Override
        public int getRemainingTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public void addToTimeout(int timeout) {
            this.timeout += timeout;
        }

        @Override
        public void tick() {
            --this.timeout;
        }

        @Override
        public void onTimeout() {
        }

        @Override
        @Nonnull
        public E getValue() {
            return this.value;
        }

        public void setValue(@Nonnull E value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleTickToken that = (SimpleTickToken)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

