/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.api.structure;

import hellfirepvp.observerlib.api.block.MatchableState;
import hellfirepvp.observerlib.api.structure.Structure;
import hellfirepvp.observerlib.api.tile.MatchableTile;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface MatchableStructure
extends IForgeRegistryEntry<MatchableStructure>,
Structure {
    default public boolean matches(@Nonnull IBlockReader reader, @Nonnull BlockPos center) {
        for (Map.Entry entry : this.getContents().entrySet()) {
            if (this.matchesSingleBlock(reader, center, (BlockPos)entry.getKey())) continue;
            return false;
        }
        return true;
    }

    default public boolean matchesSlice(@Nonnull IBlockReader reader, @Nonnull BlockPos center, int yOffset) {
        if (this.getMinimumOffset().func_177956_o() > yOffset || this.getMaximumOffset().func_177956_o() < yOffset) {
            return true;
        }
        for (BlockPos pos2 : this.getContents().keySet().stream().filter(pos -> pos.func_177956_o() == yOffset).collect(Collectors.toList())) {
            if (this.matchesSingleBlock(reader, center, pos2)) continue;
            return false;
        }
        return true;
    }

    default public boolean matchesSingleBlock(@Nonnull IBlockReader reader, @Nonnull BlockPos center, @Nonnull BlockPos centerOffset) {
        return this.matchesSingleBlock(reader, center, centerOffset, reader.func_180495_p(center.func_177971_a((Vec3i)centerOffset)), reader.func_175625_s(center.func_177971_a((Vec3i)centerOffset)));
    }

    default public boolean matchesSingleBlock(@Nullable IBlockReader reader, @Nonnull BlockPos center, @Nonnull BlockPos centerOffset, @Nonnull BlockState comparing, @Nullable TileEntity tileEntity) {
        if (!this.hasBlockAt(centerOffset)) {
            return false;
        }
        MatchableState state = this.getBlockStateAt(centerOffset);
        MatchableTile tileMatch = this.getTileEntityAt(centerOffset);
        return state.matches(reader, center.func_177971_a((Vec3i)centerOffset), comparing) && (tileEntity == null || tileMatch == null || tileMatch.matches(reader, center.func_177971_a((Vec3i)centerOffset), tileEntity));
    }

    default public MatchableStructure setRegistryName(ResourceLocation name) {
        return this;
    }

    default public Class<MatchableStructure> getRegistryType() {
        return MatchableStructure.class;
    }
}

