/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.client.preview;

import hellfirepvp.observerlib.client.preview.StructurePreview;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;

public class StructurePreviewHandler
implements ITickHandler {
    private static final StructurePreviewHandler INSTANCE = new StructurePreviewHandler();
    private StructurePreview currentPreview = null;

    private StructurePreviewHandler() {
    }

    public static StructurePreviewHandler getInstance() {
        return INSTANCE;
    }

    void setStructurePreview(StructurePreview preview) {
        if (this.currentPreview != null) {
            this.currentPreview.onRemove();
        }
        this.currentPreview = preview;
    }

    public void attachEventListeners(IEventBus bus) {
        bus.addListener(EventPriority.HIGH, this::render);
    }

    public void attachTickHandlers(Consumer<ITickHandler> registrar) {
        registrar.accept(this);
    }

    private void render(RenderWorldLastEvent event) {
        ClientWorld renderWorld = Minecraft.func_71410_x().field_71441_e;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (renderWorld == null || player == null || this.currentPreview == null) {
            return;
        }
        if (this.currentPreview.canRender((World)renderWorld, player.func_180425_c())) {
            this.currentPreview.render((World)renderWorld, event.getMatrixStack(), player.func_174791_d());
        }
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        ClientWorld renderWorld = Minecraft.func_71410_x().field_71441_e;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (renderWorld == null || player == null) {
            this.currentPreview = null;
            return;
        }
        if (this.currentPreview != null) {
            if (!this.currentPreview.canPersist((World)renderWorld, player.func_180425_c())) {
                this.currentPreview.onRemove();
                this.currentPreview = null;
            } else {
                this.currentPreview.tick((World)renderWorld, player.func_180425_c());
            }
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.CLIENT);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "ObserverLib Structure Preview";
    }
}

