/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.api;

import hellfirepvp.observerlib.api.ChangeObserver;
import hellfirepvp.observerlib.api.ChangeSubscriber;
import hellfirepvp.observerlib.api.ObserverHelper;
import hellfirepvp.observerlib.api.ObserverProvider;
import hellfirepvp.observerlib.common.data.StructureMatchingBuffer;
import hellfirepvp.observerlib.common.data.WorldCacheDomain;
import hellfirepvp.observerlib.common.data.WorldCacheManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class MatcherObserverHelper
extends ObserverHelper {
    private static WorldCacheDomain WORLD_DOMAIN = WorldCacheManager.createDomain("observerlib");
    private static WorldCacheDomain.SaveKey<StructureMatchingBuffer> STRUCTURE_BUFFER_KEY = WORLD_DOMAIN.createSaveKey("structure_buffer", StructureMatchingBuffer::new);

    public static StructureMatchingBuffer getBuffer(IWorld world) {
        return WORLD_DOMAIN.getData(world, STRUCTURE_BUFFER_KEY);
    }

    @Override
    @Nonnull
    public <T extends ChangeObserver> ChangeSubscriber<T> observeArea(World world, BlockPos center, ObserverProvider provider) {
        return MatcherObserverHelper.getBuffer((IWorld)world).observeArea((IWorld)world, center, provider);
    }

    @Override
    public boolean removeObserver(World world, BlockPos pos) {
        return MatcherObserverHelper.getBuffer((IWorld)world).removeSubscriber(pos);
    }

    @Override
    @Nullable
    public ChangeSubscriber<? extends ChangeObserver> getSubscriber(World world, BlockPos pos) {
        return MatcherObserverHelper.getBuffer((IWorld)world).getSubscriber(pos);
    }
}

