/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.change;

import com.google.common.collect.Maps;
import hellfirepvp.observerlib.api.block.BlockChangeSet;
import hellfirepvp.observerlib.common.util.NBTHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;

public class BlockStateChangeSet
implements BlockChangeSet {
    private Map<BlockPos, BlockStateChange> changes = Maps.newHashMap();

    public void addChange(BlockPos pos, BlockPos absolute, BlockState oldState, BlockState newState) {
        BlockStateChange oldChangeSet = this.changes.get(pos);
        if (oldChangeSet != null) {
            this.changes.put(pos, new BlockStateChange(pos, absolute, oldChangeSet.oldState, newState));
        } else {
            this.changes.put(pos, new BlockStateChange(pos, absolute, oldState, newState));
        }
    }

    public final void reset() {
        this.changes.clear();
    }

    @Override
    public boolean hasChange(BlockPos pos) {
        return this.changes.containsKey(pos);
    }

    @Override
    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    @Override
    @Nonnull
    public Collection<BlockChangeSet.StateChange> getChanges() {
        return Collections.unmodifiableCollection(this.changes.values());
    }

    public void readFromNBT(CompoundNBT cmp) {
        this.changes.clear();
        ListNBT changeList = cmp.func_150295_c("changeList", 10);
        for (int i = 0; i < changeList.size(); ++i) {
            CompoundNBT changeTag = changeList.func_150305_b(i);
            BlockPos pos = NBTHelper.readBlockPosFromNBT(changeTag.func_74775_l("relPos"));
            BlockPos abs = NBTHelper.readBlockPosFromNBT(changeTag.func_74775_l("absPos"));
            BlockState oldState = NBTHelper.getBlockStateFromTag(changeTag.func_74775_l("oldState"), Blocks.field_150350_a.func_176223_P());
            BlockState newState = NBTHelper.getBlockStateFromTag(changeTag.func_74775_l("newState"), Blocks.field_150350_a.func_176223_P());
            this.changes.put(pos, new BlockStateChange(pos, abs, oldState, newState));
        }
    }

    public void writeToNBT(CompoundNBT cmp) {
        ListNBT changes = new ListNBT();
        for (BlockStateChange change : this.changes.values()) {
            CompoundNBT tag = new CompoundNBT();
            NBTHelper.setAsSubTag(tag, "relPos", posTag -> NBTHelper.writeBlockPosToNBT(change.getRelativePosition(), posTag));
            NBTHelper.setAsSubTag(tag, "absPos", posTag -> NBTHelper.writeBlockPosToNBT(change.getAbsolutePosition(), posTag));
            NBTHelper.writeBlockPosToNBT(change.pos, tag);
            tag.func_218657_a("oldState", (INBT)NBTHelper.getBlockStateNBTTag(change.oldState));
            tag.func_218657_a("newState", (INBT)NBTHelper.getBlockStateNBTTag(change.newState));
            changes.add((Object)tag);
        }
        cmp.func_218657_a("changeList", (INBT)changes);
    }

    public static final class BlockStateChange
    implements BlockChangeSet.StateChange {
        private final BlockPos pos;
        private final BlockPos abs;
        private final BlockState oldState;
        private final BlockState newState;

        private BlockStateChange(BlockPos pos, BlockPos abs, BlockState oldState, BlockState newState) {
            this.pos = pos;
            this.abs = abs;
            this.oldState = oldState;
            this.newState = newState;
        }

        @Override
        @Nonnull
        public BlockPos getAbsolutePosition() {
            return this.abs;
        }

        @Override
        @Nonnull
        public BlockPos getRelativePosition() {
            return this.pos;
        }

        @Override
        @Nonnull
        public BlockState getOldState() {
            return this.oldState;
        }

        @Override
        @Nonnull
        public BlockState getNewState() {
            return this.newState;
        }
    }
}

